/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.renderer.v1.model;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.renderer.v1.model.SpriteFinder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.data.AtlasIds;
import org.jspecify.annotations.Nullable;

public final class ModelHelper {
    private static final Direction[] FACES = Arrays.copyOf(Direction.values(), 7);
    public static final int NULL_FACE_ID = 6;

    private ModelHelper() {
    }

    public static int toFaceIndex(@Nullable Direction face) {
        return face == null ? 6 : face.get3DDataValue();
    }

    public static @Nullable Direction faceFromIndex(int faceIndex) {
        return FACES[faceIndex];
    }

    public static List<BakedQuad>[] toQuadLists(Mesh mesh) {
        SpriteFinder finder = Minecraft.getInstance().getAtlasManager().getAtlasOrThrow(AtlasIds.BLOCKS).spriteFinder();
        ImmutableList.Builder[] builders = new ImmutableList.Builder[7];
        for (int i = 0; i < 7; ++i) {
            builders[i] = ImmutableList.builder();
        }
        mesh.forEach(q -> {
            Direction cullFace = q.cullFace();
            builders[cullFace == null ? 6 : cullFace.get3DDataValue()].add((Object)q.toBakedQuad(finder.find((QuadView)q)));
        });
        List[] result = new List[7];
        for (int i = 0; i < 7; ++i) {
            result[i] = builders[i].build();
        }
        return result;
    }
}

