/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.renderer.v1.mesh;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import net.fabricmc.fabric.api.renderer.v1.mesh.ShadeMode;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;

public interface QuadView {
    public static final int VANILLA_VERTEX_STRIDE = DefaultVertexFormat.BLOCK.getVertexSize() / 4;
    public static final int VANILLA_QUAD_STRIDE = VANILLA_VERTEX_STRIDE * 4;

    public float x(int var1);

    public float y(int var1);

    public float z(int var1);

    public float posByIndex(int var1, int var2);

    public Vector3f copyPos(int var1, @Nullable Vector3f var2);

    public int color(int var1);

    public float u(int var1);

    public float v(int var1);

    public Vector2f copyUv(int var1, @Nullable Vector2f var2);

    public int lightmap(int var1);

    public boolean hasNormal(int var1);

    public float normalX(int var1);

    public float normalY(int var1);

    public float normalZ(int var1);

    public @Nullable Vector3f copyNormal(int var1, @Nullable Vector3f var2);

    public Vector3fc faceNormal();

    public Direction lightFace();

    public @Nullable Direction nominalFace();

    public @Nullable Direction cullFace();

    public @Nullable ChunkSectionLayer renderLayer();

    public boolean emissive();

    public boolean diffuseShade();

    public TriState ambientOcclusion();

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ItemStackRenderState.FoilType glint();

    public ShadeMode shadeMode();

    public int tintIndex();

    public int tag();

    public void toVanilla(int[] var1, int var2);

    default public BakedQuad toBakedQuad(TextureAtlasSprite sprite) {
        int[] vertexData = new int[VANILLA_QUAD_STRIDE];
        this.toVanilla(vertexData, 0);
        int lightEmission = 15;
        if (!this.emissive()) {
            for (int i = 0; i < 4; ++i) {
                int lightmap = this.lightmap(i);
                if (lightmap == 0) {
                    lightEmission = 0;
                    break;
                }
                int blockLight = LightTexture.block((int)lightmap);
                int skyLight = LightTexture.sky((int)lightmap);
                lightEmission = Math.min(lightEmission, Math.min(blockLight, skyLight));
            }
        }
        return new BakedQuad(vertexData, this.tintIndex(), this.lightFace(), sprite, this.diffuseShade(), lightEmission);
    }
}

