/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.renderer.client.sprite;

import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import net.fabricmc.fabric.api.renderer.v1.model.SpriteFinder;
import net.fabricmc.fabric.impl.renderer.MissingSpriteFinderImpl;
import net.minecraft.class_1058;
import net.minecraft.class_10725;
import net.minecraft.class_2960;
import net.minecraft.class_7766;
import net.minecraft.class_9826;

@Mixin(targets = "net/minecraft/client/render/model/BakedModelManager$1")
abstract class BakedModelManager1Mixin implements class_9826 {
	@Shadow
	@Final
	private class_1058 missingSprite;
	@Shadow
	@Final
	class_7766.class_7767 field_61871;

	@Unique
	@Nullable
	private volatile MissingSpriteFinderImpl missingSpriteFinder;

	@Override
	public SpriteFinder spriteFinder(class_2960 atlasId) {
		if (atlasId.equals(class_10725.field_56382)) {
			return field_61871.spriteFinder();
		}

		MissingSpriteFinderImpl result = missingSpriteFinder;

		if (result == null) {
			synchronized (this) {
				result = missingSpriteFinder;

				if (result == null) {
					missingSpriteFinder = result = new MissingSpriteFinderImpl(missingSprite);
				}
			}
		}

		return result;
	}
}
