/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.renderer.client.block.render;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.impl.renderer.BatchingRenderCommandQueueExtension;
import net.fabricmc.fabric.impl.renderer.ExtendedBlockCommand;
import net.fabricmc.fabric.impl.renderer.ExtendedBlockStateModelCommand;
import net.minecraft.class_1087;
import net.minecraft.class_11515;
import net.minecraft.class_11661;
import net.minecraft.class_11785;
import net.minecraft.class_11788;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_811;

@Mixin(class_11788.class)
abstract class BatchingRenderCommandQueueMixin implements class_11785, BatchingRenderCommandQueueExtension {
	@Shadow
	@Final
	private class_11661 orderedQueueImpl;
	@Shadow
	private boolean hasCommands;

	@Unique
	private final List<ExtendedBlockCommand> extendedBlockCommands = new ArrayList<>();
	@Unique
	private final List<ExtendedBlockStateModelCommand> extendedBlockStateModelCommands = new ArrayList<>();

	@Override
	public void submitBlock(class_4587 matrices, class_2680 state, int light, int overlay, int outlineColor, class_1920 blockView, class_2338 pos) {
		hasCommands = true;
		extendedBlockCommands.add(new ExtendedBlockCommand(matrices.method_23760().method_56822(), state, light, overlay, outlineColor, blockView, pos));
		class_310.method_1551().method_1554().method_65756().get().method_65535(state.method_26204(), class_811.field_4315, matrices, orderedQueueImpl, light, overlay);
	}

	@Override
	public void submitBlockStateModel(class_4587 matrices, Function<class_11515, class_1921> renderLayerFunction, class_1087 model, float r, float g, float b, int light, int overlay, int outlineColor, class_1920 blockView, class_2338 pos, class_2680 state) {
		hasCommands = true;
		extendedBlockStateModelCommands.add(new ExtendedBlockStateModelCommand(matrices.method_23760().method_56822(), renderLayerFunction, model, r, g, b, light, overlay, outlineColor, blockView, pos, state));
	}

	@Override
	public List<ExtendedBlockCommand> fabric_getExtendedBlockCommands() {
		return extendedBlockCommands;
	}

	@Override
	public List<ExtendedBlockStateModelCommand> fabric_getExtendedBlockStateModelCommands() {
		return extendedBlockStateModelCommands;
	}

	@Inject(method = "clear", at = @At("RETURN"))
	private void onReturnClear(CallbackInfo ci) {
		extendedBlockCommands.clear();
		extendedBlockStateModelCommands.clear();
	}
}
