/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.renderer.client.block.render;

import java.util.Iterator;

import com.llamalad7.mixinextras.sugar.Local;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.api.renderer.v1.render.RenderLayerHelper;
import net.minecraft.class_1087;
import net.minecraft.class_11661;
import net.minecraft.class_11681;
import net.minecraft.class_11788;
import net.minecraft.class_11791;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4618;
import net.minecraft.class_776;

@Mixin(class_11681.class)
abstract class FallingBlockCommandRendererMixin {
	@Shadow
	@Final
	private class_4587 matrices;

	// Support multi-render layer models (FallingBlockCommand).
	@Inject(method = "render", at = @At(value = "INVOKE", target = "java/util/Iterator.hasNext()Z", ordinal = 0))
	private void beforeRenderFallingBlocks(class_11788 queue, class_4597.class_4598 vertexConsumers, class_776 blockRenderManager, class_4618 outlineVertexConsumerProvider, CallbackInfo ci, @Local Iterator<class_11661.class_11790> iterator) {
		while (iterator.hasNext()) {
			class_11661.class_11790 fallingBlockCommand = iterator.next();
			class_11791 renderState = fallingBlockCommand.comp_4653();
			class_2680 blockState = renderState.field_62247;
			class_1087 model = blockRenderManager.method_3349(blockState);
			long seed = blockState.method_26190(renderState.field_62245);
			matrices.method_22903();
			matrices.method_34425(fallingBlockCommand.comp_4652());
			blockRenderManager.method_3350().render(renderState, model, blockState, renderState.field_62246, matrices, RenderLayerHelper.movingDelegate(vertexConsumers), false, seed, class_4608.field_21444);
			matrices.method_22909();
		}
	}
}
