/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.renderer.client.block.render;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import net.fabricmc.fabric.api.renderer.v1.render.RenderLayerHelper;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_776;
import net.minecraft.class_835;

@Mixin(class_835.class)
abstract class PistonBlockEntityRendererMixin {
	@Shadow
	@Final
	private class_776 manager;

	// Support multi-render layer models.
	@Overwrite
	private void renderModel(class_2338 pos, class_2680 state, class_4587 matrices, class_4597 vertexConsumers, class_1937 world, boolean cull, int overlay) {
		manager.method_3350().render(world, manager.method_3349(state), state, pos, matrices, layer -> vertexConsumers.getBuffer(RenderLayerHelper.getMovingBlockLayer(layer)), cull, state.method_26190(pos), overlay);
	}
}
