/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.renderer.v1.material;

import net.minecraft.class_10444;
import org.jetbrains.annotations.Nullable;

/**
 * Controls how glint should be applied.
 */
public enum GlintMode {
	/**
	 * Use the glint {@linkplain class_10444.class_10446#method_65615(class_10444.class_10445) set in the layer}.
	 */
	DEFAULT(null),
	NONE(class_10444.class_10445.field_55341),
	STANDARD(class_10444.class_10445.field_55342),
	SPECIAL(class_10444.class_10445.field_55343);

	@Nullable
	public final class_10444.class_10445 glint;

	GlintMode(@Nullable class_10444.class_10445 glint) {
		this.glint = glint;
	}

	public static GlintMode fromGlint(@Nullable class_10444.class_10445 glint) {
		return switch (glint) {
		case null -> DEFAULT;
		case field_55341 -> NONE;
		case field_55342 -> STANDARD;
		case field_55343 -> SPECIAL;
		};
	}
}
