/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.registry.sync;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.fabricmc.fabric.api.event.registry.RegistryAttributeHolder;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.impl.registry.sync.packet.RegistrySyncPayload;
import net.minecraft.class_7923;

public class FabricRegistryInit implements ModInitializer {
	private static final int MAX_PACKET_SIZE = Integer.getInteger("fabric.registry.sync.max_packet_size", 128 * 1024 * 1024);

	@Override
	public void onInitialize() {
		PayloadTypeRegistry.configurationC2S().register(SyncCompletePayload.ID, SyncCompletePayload.CODEC);
		PayloadTypeRegistry.configurationS2C().registerLarge(RegistrySyncPayload.ID, RegistrySyncPayload.CODEC, MAX_PACKET_SIZE);

		ServerConfigurationConnectionEvents.BEFORE_CONFIGURE.register(RegistrySyncManager::configureClient);
		ServerConfigurationNetworking.registerGlobalReceiver(SyncCompletePayload.ID, (payload, context) -> {
			context.networkHandler().completeTask(RegistrySyncManager.SyncConfigurationTask.KEY);
		});

		// Synced in PlaySoundS2CPacket.
		RegistryAttributeHolder.get(class_7923.field_41172)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced with RegistryTagContainer from RegistryTagManager.
		RegistryAttributeHolder.get(class_7923.field_41173)
				.addAttribute(RegistryAttribute.SYNCED);

		// StatusEffectInstance serialises with raw id.
		RegistryAttributeHolder.get(class_7923.field_41174)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced in ChunkDeltaUpdateS2CPacket among other places, a pallet is used when saving.
		RegistryAttributeHolder.get(class_7923.field_41175)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced in EntitySpawnS2CPacket and RegistryTagManager
		RegistryAttributeHolder.get(class_7923.field_41177)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced in RegistryTagManager
		RegistryAttributeHolder.get(class_7923.field_41178)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced via PacketCodecs.registry
		RegistryAttributeHolder.get(class_7923.field_41179)
				.addAttribute(RegistryAttribute.SYNCED);

		// Doesnt seem to be accessed apart from registering?
		RegistryAttributeHolder.get(class_7923.field_41143);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_7923.field_41144);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_7923.field_41149);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_7923.field_41150);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_7923.field_41151);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_7923.field_41153);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_7923.field_41155);

		// Synced in ParticleS2CPacket
		RegistryAttributeHolder.get(class_7923.field_41180)
				.addAttribute(RegistryAttribute.SYNCED);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_7923.field_41156);

		// Synced. Vanilla uses raw ids in BlockEntityUpdateS2CPacket, and mods use the Vanilla syncing since 1.18
		RegistryAttributeHolder.get(class_7923.field_41181)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced via PacketCodecs.registry
		RegistryAttributeHolder.get(class_7923.field_41183)
				.addAttribute(RegistryAttribute.SYNCED);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_7923.field_41184);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_7923.field_41147);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_7923.field_41146);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_7923.field_41185);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_7923.field_41186);

		RegistryAttributeHolder.get(class_7923.field_41161);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_7923.field_41162);

		//  Uses the raw ID when syncing the command tree to the client
		RegistryAttributeHolder.get(class_7923.field_41192)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced in OpenScreenS2CPacket
		RegistryAttributeHolder.get(class_7923.field_41187)
				.addAttribute(RegistryAttribute.SYNCED);

		// Does not seem to be serialised, only queried by id. Not synced
		RegistryAttributeHolder.get(class_7923.field_41188);

		// Synced by rawID in 24w03a+
		RegistryAttributeHolder.get(class_7923.field_41190)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced in StatisticsS2CPacket
		RegistryAttributeHolder.get(class_7923.field_41193)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced by rawID in TrackedDataHandlerRegistry.VILLAGER_DATA
		RegistryAttributeHolder.get(class_7923.field_41194)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced by rawID in TrackedDataHandlerRegistry.VILLAGER_DATA
		RegistryAttributeHolder.get(class_7923.field_41195)
				.addAttribute(RegistryAttribute.SYNCED);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_7923.field_41128);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_7923.field_41129);

		// Doesnt seem to be serialised or synced.
		RegistryAttributeHolder.get(class_7923.field_41130);

		// Doesnt seem to be serialised or synced.
		RegistryAttributeHolder.get(class_7923.field_41131);

		// Doesnt seem to be serialised or synced.
		RegistryAttributeHolder.get(class_7923.field_41132);

		// Doesnt seem to be serialised or synced.
		RegistryAttributeHolder.get(class_7923.field_41133);

		// Doesnt seem to be serialised or synced.
		RegistryAttributeHolder.get(class_7923.field_41134);

		// Doesnt seem to be serialised or synced.
		RegistryAttributeHolder.get(class_7923.field_41135);

		// Synced in TagManager::toPacket/fromPacket -> TagGroup::serialize/deserialize
		RegistryAttributeHolder.get(class_7923.field_41171)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced by rawID in its serialization code.
		RegistryAttributeHolder.get(class_7923.field_47555)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced by rawID.
		RegistryAttributeHolder.get(class_7923.field_41191)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced by rawID.
		RegistryAttributeHolder.get(class_7923.field_49658)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced by rawID.
		RegistryAttributeHolder.get(class_7923.field_56404)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced by rawID.
		RegistryAttributeHolder.get(class_7923.field_50078)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced via PacketCodecs.registry
		RegistryAttributeHolder.get(class_7923.field_53967)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced via PacketCodecs.registryValue
		RegistryAttributeHolder.get(class_7923.field_54874)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced via PacketCodecs.registryValue
		RegistryAttributeHolder.get(class_7923.field_54873)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced via PacketCodecs.registryValue
		RegistryAttributeHolder.get(class_7923.field_54927)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced via PacketCodecs.registryValue
		RegistryAttributeHolder.get(class_7923.field_41128)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced via PacketCodecs.registryValue
		RegistryAttributeHolder.get(class_7923.field_62996)
				.addAttribute(RegistryAttribute.SYNCED);
	}
}
