/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.registry.sync.packet;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.fabricmc.fabric.api.event.registry.RegistryAttributeHolder;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.impl.registry.sync.packet.RegistryPacketHandler;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class DirectRegistryPacketHandler
extends RegistryPacketHandler<Payload> {
    private static final int MAX_PAYLOAD_SIZE = Integer.getInteger("fabric.registry.direct.maxPayloadSize", 0x100000);
    @Nullable
    private class_2540 combinedBuf;
    @Nullable
    private Map<class_2960, Object2IntMap<class_2960>> syncedRegistryMap;
    @Nullable
    private Map<class_2960, EnumSet<RegistryAttribute>> syncedRegistryAttributes;
    private boolean isPacketFinished = false;
    private int totalPacketReceived = 0;

    @Override
    public class_8710.class_9154<Payload> getPacketId() {
        return Payload.ID;
    }

    @Override
    public void sendPacket(Consumer<Payload> sender, Map<class_2960, Object2IntMap<class_2960>> registryMap) {
        int sliceSize;
        class_2540 buf = PacketByteBufs.create();
        Map<String, List<class_2960>> regNamespaceGroups = registryMap.keySet().stream().collect(Collectors.groupingBy(class_2960::method_12836));
        buf.method_10804(regNamespaceGroups.size());
        regNamespaceGroups.forEach((regNamespace, regIds) -> {
            buf.method_10814(DirectRegistryPacketHandler.optimizeNamespace(regNamespace));
            buf.method_10804(regIds.size());
            for (class_2960 regId : regIds) {
                buf.method_10814(regId.method_12832());
                buf.method_52997((int)DirectRegistryPacketHandler.encodeRegistryAttributes(regId));
                Object2IntMap idMap = (Object2IntMap)registryMap.get(regId);
                Map idNamespaceGroups = idMap.object2IntEntrySet().stream().collect(Collectors.groupingBy(e -> ((class_2960)e.getKey()).method_12836(), LinkedHashMap::new, Collectors.toCollection(ArrayList::new)));
                buf.method_10804(idNamespaceGroups.size());
                int lastBulkLastRawId = 0;
                for (Map.Entry idNamespaceEntry : idNamespaceGroups.entrySet()) {
                    List idPairs = (List)idNamespaceEntry.getValue();
                    idPairs.sort(Comparator.comparingInt(Object2IntMap.Entry::getIntValue));
                    ArrayList bulks = new ArrayList();
                    Iterator idPairIter = idPairs.iterator();
                    ArrayList<Object2IntMap.Entry> currentBulk = new ArrayList<Object2IntMap.Entry>();
                    Object2IntMap.Entry currentPair = (Object2IntMap.Entry)idPairIter.next();
                    currentBulk.add(currentPair);
                    while (idPairIter.hasNext()) {
                        currentPair = (Object2IntMap.Entry)idPairIter.next();
                        if (((Object2IntMap.Entry)currentBulk.get(currentBulk.size() - 1)).getIntValue() + 1 != currentPair.getIntValue()) {
                            bulks.add(currentBulk);
                            currentBulk = new ArrayList();
                        }
                        currentBulk.add(currentPair);
                    }
                    bulks.add(currentBulk);
                    buf.method_10814(DirectRegistryPacketHandler.optimizeNamespace((String)idNamespaceEntry.getKey()));
                    buf.method_10804(bulks.size());
                    for (List list : bulks) {
                        int firstRawId = ((Object2IntMap.Entry)list.get(0)).getIntValue();
                        int bulkRawIdStartDiff = firstRawId - lastBulkLastRawId;
                        buf.method_10804(bulkRawIdStartDiff);
                        buf.method_10804(list.size());
                        for (Object2IntMap.Entry idPair : list) {
                            buf.method_10814(((class_2960)idPair.getKey()).method_12832());
                            lastBulkLastRawId = idPair.getIntValue();
                        }
                    }
                }
            }
        });
        int readableBytes = buf.readableBytes();
        for (int sliceIndex = 0; sliceIndex < readableBytes; sliceIndex += sliceSize) {
            sliceSize = Math.min(readableBytes - sliceIndex, MAX_PAYLOAD_SIZE);
            class_2540 slicedBuf = PacketByteBufs.slice((ByteBuf)buf, (int)sliceIndex, (int)sliceSize);
            sender.accept(this.createPayload(slicedBuf));
        }
        sender.accept(this.createPayload(PacketByteBufs.empty()));
    }

    @Override
    public void receivePayload(Payload payload) {
        byte[] data;
        Preconditions.checkState((!this.isPacketFinished ? 1 : 0) != 0);
        ++this.totalPacketReceived;
        if (this.combinedBuf == null) {
            this.combinedBuf = PacketByteBufs.create();
        }
        if ((data = payload.data()).length != 0) {
            this.combinedBuf.method_52983(data);
            return;
        }
        this.isPacketFinished = true;
        this.computeBufSize(this.combinedBuf);
        this.syncedRegistryMap = new LinkedHashMap<class_2960, Object2IntMap<class_2960>>();
        this.syncedRegistryAttributes = new LinkedHashMap<class_2960, EnumSet<RegistryAttribute>>();
        int regNamespaceGroupAmount = this.combinedBuf.method_10816();
        for (int i = 0; i < regNamespaceGroupAmount; ++i) {
            String regNamespace = DirectRegistryPacketHandler.unoptimizeNamespace(this.combinedBuf.method_19772());
            int regNamespaceGroupLength = this.combinedBuf.method_10816();
            for (int j = 0; j < regNamespaceGroupLength; ++j) {
                String regPath = this.combinedBuf.method_19772();
                EnumSet<RegistryAttribute> attributes = DirectRegistryPacketHandler.decodeRegistryAttributes(this.combinedBuf.readByte());
                Object2IntLinkedOpenHashMap idMap = new Object2IntLinkedOpenHashMap();
                int idNamespaceGroupAmount = this.combinedBuf.method_10816();
                int lastBulkLastRawId = 0;
                for (int k = 0; k < idNamespaceGroupAmount; ++k) {
                    String idNamespace = DirectRegistryPacketHandler.unoptimizeNamespace(this.combinedBuf.method_19772());
                    int rawIdBulkAmount = this.combinedBuf.method_10816();
                    for (int l = 0; l < rawIdBulkAmount; ++l) {
                        int bulkRawIdStartDiff = this.combinedBuf.method_10816();
                        int bulkSize = this.combinedBuf.method_10816();
                        int currentRawId = lastBulkLastRawId + bulkRawIdStartDiff - 1;
                        for (int m = 0; m < bulkSize; ++m) {
                            String idPath = this.combinedBuf.method_19772();
                            idMap.put((Object)class_2960.method_60655((String)idNamespace, (String)idPath), ++currentRawId);
                        }
                        lastBulkLastRawId = currentRawId;
                    }
                }
                class_2960 registryId = class_2960.method_60655((String)regNamespace, (String)regPath);
                this.syncedRegistryMap.put(registryId, (Object2IntMap<class_2960>)idMap);
                this.syncedRegistryAttributes.put(registryId, attributes);
            }
        }
        this.combinedBuf.release();
        this.combinedBuf = null;
    }

    @Override
    public boolean isPacketFinished() {
        return this.isPacketFinished;
    }

    @Override
    public int getTotalPacketReceived() {
        Preconditions.checkState((boolean)this.isPacketFinished);
        return this.totalPacketReceived;
    }

    @Override
    @Nullable
    public RegistryPacketHandler.SyncedPacketData getSyncedPacketData() {
        Preconditions.checkState((boolean)this.isPacketFinished);
        if (this.syncedRegistryMap == null || this.syncedRegistryAttributes == null) {
            return null;
        }
        Map<class_2960, Object2IntMap<class_2960>> map = Collections.unmodifiableMap(this.syncedRegistryMap);
        Map<class_2960, EnumSet<RegistryAttribute>> attributes = Collections.unmodifiableMap(this.syncedRegistryAttributes);
        this.isPacketFinished = false;
        this.totalPacketReceived = 0;
        this.syncedRegistryMap = null;
        this.syncedRegistryAttributes = null;
        return new RegistryPacketHandler.SyncedPacketData(map, attributes);
    }

    private Payload createPayload(class_2540 buf) {
        if (buf.readableBytes() == 0) {
            return new Payload(new byte[0]);
        }
        return new Payload(buf.array());
    }

    private static String optimizeNamespace(String namespace) {
        return namespace.equals("minecraft") ? "" : namespace;
    }

    private static String unoptimizeNamespace(String namespace) {
        return namespace.isEmpty() ? "minecraft" : namespace;
    }

    private static byte encodeRegistryAttributes(class_2960 identifier) {
        class_2378 registry = (class_2378)class_7923.field_41167.method_63535(identifier);
        if (registry == null) {
            return 0;
        }
        RegistryAttributeHolder holder = RegistryAttributeHolder.get(registry);
        byte encoded = 0;
        if (holder.hasAttribute(RegistryAttribute.OPTIONAL)) {
            encoded = (byte)(encoded | 1);
        }
        return encoded;
    }

    private static EnumSet<RegistryAttribute> decodeRegistryAttributes(byte encoded) {
        EnumSet<RegistryAttribute> attributes = EnumSet.noneOf(RegistryAttribute.class);
        if ((encoded & 1) != 0) {
            attributes.add(RegistryAttribute.OPTIONAL);
        }
        return attributes;
    }

    public record Payload(byte[] data) implements RegistryPacketHandler.RegistrySyncPayload
    {
        public static class_8710.class_9154<Payload> ID = new class_8710.class_9154(class_2960.method_60655((String)"fabric", (String)"registry/sync/direct"));
        public static class_9139<class_2540, Payload> CODEC = class_8710.method_56484(Payload::write, Payload::new);

        Payload(class_2540 buf) {
            this(Payload.readAllBytes(buf));
        }

        private void write(class_2540 buf) {
            buf.method_52983(this.data);
        }

        private static byte[] readAllBytes(class_2540 buf) {
            byte[] bytes = new byte[buf.readableBytes()];
            buf.method_52979(bytes);
            return bytes;
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }
}

