/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.registry.sync;

import java.util.concurrent.CompletionException;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.impl.client.registry.sync.ClientRegistrySyncHandler;
import net.fabricmc.fabric.impl.registry.sync.RegistrySyncManager;
import net.fabricmc.fabric.impl.registry.sync.RemapException;
import net.fabricmc.fabric.impl.registry.sync.SyncCompletePayload;
import net.fabricmc.fabric.impl.registry.sync.packet.RegistryPacketHandler;
import net.minecraft.class_2561;
import net.minecraft.class_8710;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class FabricRegistryClientInit
implements ClientModInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(FabricRegistryClientInit.class);

    public void onInitializeClient() {
        this.registerSyncPacketReceiver(RegistrySyncManager.DIRECT_PACKET_HANDLER);
    }

    private <T extends RegistryPacketHandler.RegistrySyncPayload> void registerSyncPacketReceiver(RegistryPacketHandler<T> packetHandler) {
        ClientConfigurationNetworking.registerGlobalReceiver(packetHandler.getPacketId(), (payload, context) -> ClientRegistrySyncHandler.receivePacket(context.client(), packetHandler, payload, RegistrySyncManager.DEBUG || !context.client().method_1542()).whenComplete((complete, throwable) -> {
            if (throwable != null) {
                LOGGER.error("Registry remapping failed!", throwable);
                context.client().execute(() -> context.responseSender().disconnect(this.getText((Throwable)throwable)));
                return;
            }
            if (complete.booleanValue()) {
                context.responseSender().sendPacket((class_8710)SyncCompletePayload.INSTANCE);
            }
        }));
    }

    private class_2561 getText(Throwable e) {
        if (e instanceof RemapException) {
            RemapException remapException = (RemapException)e;
            class_2561 text = remapException.getText();
            if (text != null) {
                return text;
            }
        } else if (e instanceof CompletionException) {
            CompletionException completionException = (CompletionException)e;
            return this.getText(completionException.getCause());
        }
        return class_2561.method_43470((String)("Registry remapping failed: " + e.getMessage()));
    }
}

