/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.recipe.sync;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_10941;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_8786;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

/**
 * Main packet used to send recipes to the client.
 */
public record RecipeSyncPayloadS2C(List<Entry> entries) implements class_8710 {
	public static final class_9139<class_9129, RecipeSyncPayloadS2C> CODEC = Entry.CODEC.method_56433(class_9135.method_56363()).method_56432(RecipeSyncPayloadS2C::new, RecipeSyncPayloadS2C::entries);

	public static final class_9154<RecipeSyncPayloadS2C> ID = new class_9154<>(class_2960.method_60655("fabric", "recipe_sync"));

	@Override
	public class_9154<? extends class_8710> method_56479() {
		return ID;
	}

	public record Entry(class_1865<?> serializer, List<class_8786<?>> recipes) {
		public static final class_9139<class_9129, Entry> CODEC = class_9139.method_56438(
				Entry::write,
				Entry::read
		);

		private static Entry read(class_9129 buf) {
			class_2960 recipeSerializerId = buf.method_10810();
			class_1865<?> recipeSerializer = class_7923.field_41189.method_63535(recipeSerializerId);

			if (recipeSerializer == null || !RecipeSyncImpl.isSynced(recipeSerializer)) {
				throw new class_10941("Tried syncing unsupported packet serializer '" + recipeSerializerId + "'!");
			}

			int count = buf.method_10816();
			var list = new ArrayList<class_8786<?>>();

			for (int i = 0; i < count; i++) {
				class_5321<class_1860<?>> id = buf.method_44112(class_7924.field_52178);
				//noinspection deprecation
				class_1860<?> recipe = recipeSerializer.method_56104().decode(buf);
				list.add(new class_8786<>(id, recipe));
			}

			return new Entry(recipeSerializer, list);
		}

		private void write(class_9129 buf) {
			buf.method_10812(class_7923.field_41189.method_10221(this.serializer));

			buf.method_10804(this.recipes.size());

			//noinspection unchecked,deprecation
			class_9139<class_9129, class_1860<?>> serializer = ((class_9139<class_9129, class_1860<?>>) this.serializer.method_56104());

			for (class_8786<?> recipe : this.recipes) {
				buf.method_44116(recipe.comp_1932());
				serializer.encode(buf, recipe.comp_1933());
			}
		}
	}
}
