/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.recipe.ingredient;

import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.impl.recipe.ingredient.CustomIngredientImpl;
import net.fabricmc.fabric.impl.recipe.ingredient.CustomIngredientPayloadC2S;
import net.fabricmc.fabric.impl.recipe.ingredient.CustomIngredientPayloadS2C;
import net.fabricmc.fabric.impl.recipe.ingredient.SupportedIngredientsClientConnection;
import net.fabricmc.fabric.mixin.networking.accessor.ServerCommonPacketListenerImplAccessor;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;

public class CustomIngredientSync
implements ModInitializer {
    public static final Identifier PACKET_ID = Identifier.fromNamespaceAndPath((String)"fabric", (String)"custom_ingredient_sync");
    public static final int PROTOCOL_VERSION_1 = 1;
    public static final ThreadLocal<Set<Identifier>> CURRENT_SUPPORTED_INGREDIENTS = new ThreadLocal();

    public static CustomIngredientPayloadC2S createResponsePayload(int serverProtocolVersion) {
        if (serverProtocolVersion < 1) {
            return null;
        }
        return new CustomIngredientPayloadC2S(1, CustomIngredientImpl.REGISTERED_SERIALIZERS.keySet());
    }

    public static Set<Identifier> decodeResponsePayload(CustomIngredientPayloadC2S payload) {
        int protocolVersion = payload.protocolVersion();
        switch (protocolVersion) {
            case 1: {
                Set<Identifier> serializers = payload.registeredSerializers();
                serializers.removeIf(id -> !CustomIngredientImpl.REGISTERED_SERIALIZERS.containsKey(id));
                return serializers;
            }
        }
        throw new IllegalArgumentException("Unknown ingredient sync protocol version: " + protocolVersion);
    }

    public void onInitialize() {
        PayloadTypeRegistry.configurationC2S().register(CustomIngredientPayloadC2S.ID, CustomIngredientPayloadC2S.CODEC);
        PayloadTypeRegistry.configurationS2C().register(CustomIngredientPayloadS2C.ID, CustomIngredientPayloadS2C.CODEC);
        ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> {
            if (ServerConfigurationNetworking.canSend((ServerConfigurationPacketListenerImpl)handler, (Identifier)PACKET_ID)) {
                handler.addTask((ConfigurationTask)new IngredientSyncTask());
            }
        });
        ServerConfigurationNetworking.registerGlobalReceiver(CustomIngredientPayloadC2S.ID, (payload, context) -> {
            Set<Identifier> supportedCustomIngredients = CustomIngredientSync.decodeResponsePayload(payload);
            ((SupportedIngredientsClientConnection)((ServerCommonPacketListenerImplAccessor)context.networkHandler()).getConnection()).fabric_setSupportedCustomIngredients(supportedCustomIngredients);
            context.networkHandler().completeTask(IngredientSyncTask.KEY);
        });
    }

    private record IngredientSyncTask() implements ConfigurationTask
    {
        public static final ConfigurationTask.Type KEY = new ConfigurationTask.Type(PACKET_ID.toString());

        public void start(Consumer<Packet<?>> sender) {
            sender.accept(ServerConfigurationNetworking.createS2CPacket((CustomPacketPayload)new CustomIngredientPayloadS2C(1)));
        }

        public ConfigurationTask.Type type() {
            return KEY;
        }
    }
}

