/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.recipe.client.sync;

import java.util.HashSet;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.impl.recipe.sync.RecipeSyncImpl;
import net.fabricmc.fabric.impl.recipe.sync.SupportedRecipeSerializersPayloadC2S;
import net.minecraft.class_1865;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_8674;
import net.minecraft.class_9250;

@Mixin(class_8674.class)
public class ClientConfigurationPacketListenerImplMixin {
	@Inject(method = "handleSelectKnownPacks", at = @At("TAIL"))
	private void sendSupportedRecipeSerializers(class_9250 packet, CallbackInfo ci) {
		if (!ClientConfigurationNetworking.canSend(SupportedRecipeSerializersPayloadC2S.ID)) {
			return;
		}

		var ids = new HashSet<class_2960>();

		for (class_1865<?> serializer : RecipeSyncImpl.getSyncedSerializers()) {
			ids.add(class_7923.field_41189.method_10221(serializer));
		}

		// No need to send empty requests, it's the default state anyway.
		if (ids.isEmpty()) {
			return;
		}

		ClientConfigurationNetworking.send(new SupportedRecipeSerializersPayloadC2S(ids));
	}
}
