/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.recipe.sync;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;

import org.jetbrains.annotations.Nullable;
import net.fabricmc.fabric.api.recipe.v1.sync.SynchronizedRecipes;
import net.minecraft.class_10289;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_8786;
import net.minecraft.class_9695;

public record SynchronizedRecipesImpl(class_10289 preparedRecipes) implements SynchronizedRecipes {
	public static final SynchronizedRecipesImpl EMPTY = new SynchronizedRecipesImpl(class_10289.field_54643);

	public static SynchronizedRecipesImpl of(Iterable<class_8786<?>> recipes) {
		return new SynchronizedRecipesImpl(class_10289.method_64700(recipes));
	}

	@Override
	public <I extends class_9695, T extends class_1860<I>> Stream<class_8786<T>> getAllMatches(class_3956<T> type, I input, class_1937 world) {
		return this.preparedRecipes.method_64699(type, input, world);
	}

	@Override
	public <I extends class_9695, T extends class_1860<I>> Collection<class_8786<T>> getAllOfType(class_3956<T> type) {
		return this.preparedRecipes.method_64698(type);
	}

	@Override
	public <I extends class_9695, T extends class_1860<I>> Optional<class_8786<T>> getFirstMatch(class_3956<T> type, I input, class_1937 world) {
		return this.preparedRecipes.method_64699(type, input, world).findFirst();
	}

	@Override
	public @Nullable class_8786<?> get(class_5321<class_1860<?>> key) {
		return this.preparedRecipes.method_64696(key);
	}

	@Override
	public Collection<class_8786<?>> recipes() {
		return this.preparedRecipes.method_64695();
	}
}
