/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.recipe.ingredient;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class CustomIngredientImpl
extends class_1856 {
    public static final String TYPE_KEY = "fabric:type";
    static final Map<class_2960, CustomIngredientSerializer<?>> REGISTERED_SERIALIZERS = new ConcurrentHashMap();
    public static final Codec<CustomIngredientSerializer<?>> CODEC = class_2960.field_25139.flatXmap(identifier -> Optional.ofNullable(REGISTERED_SERIALIZERS.get(identifier)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown custom ingredient serializer: " + String.valueOf(identifier))), serializer -> DataResult.success((Object)serializer.getIdentifier()));
    private final CustomIngredient customIngredient;

    public static void registerSerializer(CustomIngredientSerializer<?> serializer) {
        Objects.requireNonNull(serializer.getIdentifier(), "CustomIngredientSerializer identifier may not be null.");
        if (REGISTERED_SERIALIZERS.putIfAbsent(serializer.getIdentifier(), serializer) != null) {
            throw new IllegalArgumentException("CustomIngredientSerializer with identifier " + String.valueOf(serializer.getIdentifier()) + " already registered.");
        }
    }

    @Nullable
    public static CustomIngredientSerializer<?> getSerializer(class_2960 identifier) {
        Objects.requireNonNull(identifier, "Identifier may not be null.");
        return REGISTERED_SERIALIZERS.get(identifier);
    }

    public CustomIngredientImpl(CustomIngredient customIngredient) {
        super(Stream.empty());
        this.customIngredient = customIngredient;
    }

    public CustomIngredient getCustomIngredient() {
        return this.customIngredient;
    }

    public boolean requiresTesting() {
        return this.customIngredient.requiresTesting();
    }

    public class_1799[] method_8105() {
        if (this.field_9018 == null) {
            this.field_9018 = (class_1799[])this.customIngredient.getMatchingStacks().toArray(class_1799[]::new);
        }
        return this.field_9018;
    }

    public boolean method_8093(@Nullable class_1799 stack) {
        return stack != null && this.customIngredient.test(stack);
    }

    public boolean method_8103() {
        return this.field_9018 != null && this.field_9018.length == 0;
    }
}

