/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.recipe.ingredient.builtin;

import java.util.List;
import java.util.function.Function;

import com.mojang.serialization.MapCodec;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

/**
 * Base class for ALL and ANY ingredients.
 */
abstract class CombinedIngredient implements CustomIngredient {
	protected final List<class_1856> ingredients;

	protected CombinedIngredient(List<class_1856> ingredients) {
		if (ingredients.isEmpty()) {
			throw new IllegalArgumentException("ALL or ANY ingredient must have at least one sub-ingredient");
		}

		this.ingredients = ingredients;
	}

	@Override
	public boolean requiresTesting() {
		for (class_1856 ingredient : ingredients) {
			if (ingredient.requiresTesting()) {
				return true;
			}
		}

		return false;
	}

	List<class_1856> getIngredients() {
		return ingredients;
	}

	static class Serializer<I extends CombinedIngredient> implements CustomIngredientSerializer<I> {
		private final class_2960 identifier;
		private final MapCodec<I> allowEmptyCodec;
		private final MapCodec<I> disallowEmptyCodec;
		private final class_9139<class_9129, I> packetCodec;

		Serializer(class_2960 identifier, Function<List<class_1856>, I> factory, MapCodec<I> allowEmptyCodec, MapCodec<I> disallowEmptyCodec) {
			this.identifier = identifier;
			this.allowEmptyCodec = allowEmptyCodec;
			this.disallowEmptyCodec = disallowEmptyCodec;
			this.packetCodec = class_1856.field_48355.method_56433(class_9135.method_56363())
					.method_56432(factory, I::getIngredients);
		}

		@Override
		public class_2960 getIdentifier() {
			return identifier;
		}

		@Override
		public MapCodec<I> getCodec(boolean allowEmpty) {
			return allowEmpty ? allowEmptyCodec : disallowEmptyCodec;
		}

		@Override
		public class_9139<class_9129, I> getPacketCodec() {
			return this.packetCodec;
		}
	}
}
