/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.particle;

import it.unimi.dsi.fastutil.objects.Reference2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.particle.v1.ParticleRendererRegistry;
import net.fabricmc.fabric.impl.base.toposort.NodeSorting;
import net.fabricmc.fabric.impl.base.toposort.SortableNode;
import net.fabricmc.fabric.mixin.client.particle.ParticleManagerAccessor;
import net.minecraft.class_11938;
import net.minecraft.class_2960;
import net.minecraft.class_3999;
import net.minecraft.class_702;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class ParticleRendererRegistryImpl {
    public static final ParticleRendererRegistryImpl INSTANCE = new ParticleRendererRegistryImpl(ParticleManagerAccessor.getParticleTextureSheets());
    private final List<class_3999> textureSheets;
    private final Map<class_2960, ParticleTextureNode> nodes = new HashMap<class_2960, ParticleTextureNode>();
    private final IdentityHashMap<class_3999, Function<class_702, class_11938<?>>> factories = new IdentityHashMap();

    @VisibleForTesting
    public ParticleRendererRegistryImpl(List<class_3999> textureSheets) {
        ArrayList<class_3999> copyOfTextureSheets = new ArrayList<class_3999>(textureSheets);
        this.textureSheets = textureSheets;
        class_2960 last = null;
        for (class_3999 sheet : this.textureSheets) {
            class_2960 id = ParticleRendererRegistry.getId(sheet);
            this.nodes.put(id, new ParticleTextureNode(sheet));
            if (last != null) {
                ParticleTextureNode.link((SortableNode)this.nodes.get(last), (SortableNode)this.nodes.get(id));
            }
            last = id;
        }
        this.sort();
        ParticleRendererRegistryImpl.assertIdentical(textureSheets, copyOfTextureSheets);
    }

    public void register(class_3999 textureSheet, Function<class_702, class_11938<?>> function) {
        class_2960 id = ParticleRendererRegistry.getId(textureSheet);
        if (this.nodes.containsKey(id)) {
            throw new IllegalArgumentException("A ParticleTextureSheet with the id " + String.valueOf(id) + " has already been registered.");
        }
        if (this.factories.containsKey(textureSheet)) {
            throw new IllegalArgumentException("The specified ParticleTextureSheet instance has already been registered.");
        }
        ParticleTextureNode node = new ParticleTextureNode(id, textureSheet);
        this.nodes.put(id, node);
        this.textureSheets.add(textureSheet);
        this.factories.put(textureSheet, function);
        this.sort();
    }

    public void registerOrdering(class_2960 first, class_2960 second) {
        Objects.requireNonNull(first);
        Objects.requireNonNull(second);
        ParticleTextureNode firstEntry = this.nodes.get(first);
        ParticleTextureNode secondEntry = this.nodes.get(second);
        if (firstEntry == null) {
            throw new IllegalArgumentException("The specified first id " + String.valueOf(first) + " does not correspond to a registered ParticleTextureSheet.");
        }
        if (secondEntry == null) {
            throw new IllegalArgumentException("The specified second id " + String.valueOf(second) + " does not correspond to a registered ParticleTextureSheet.");
        }
        ParticleTextureNode.link((SortableNode)firstEntry, (SortableNode)secondEntry);
        this.sort();
    }

    public @Nullable class_3999 getParticleTextureSheet(class_2960 id) {
        Objects.requireNonNull(id);
        ParticleTextureNode entry = this.nodes.get(id);
        return entry != null ? entry.textureSheet : null;
    }

    public @Nullable Function<class_702, class_11938<?>> getFactory(class_3999 textureSheet) {
        return this.factories.get(textureSheet);
    }

    private void sort() {
        ArrayList<ParticleTextureNode> entries = new ArrayList<ParticleTextureNode>(this.nodes.values());
        NodeSorting.sort(entries, (String)"particle texture sheets", Comparator.comparing(a -> a.id));
        Reference2IntLinkedOpenHashMap sheets = new Reference2IntLinkedOpenHashMap();
        for (int i = 0; i < entries.size(); ++i) {
            sheets.put((Object)((ParticleTextureNode)((Object)entries.get((int)i))).textureSheet, i);
        }
        this.textureSheets.sort(Comparator.comparingInt(arg_0 -> ((Reference2IntMap)sheets).getInt(arg_0)));
    }

    private static void assertIdentical(List<?> a, List<?> b) {
        if (a.size() != b.size()) {
            throw new AssertionError((Object)("Lists differ in size: " + a.size() + " != " + b.size()));
        }
        for (int i = 0; i < a.size(); ++i) {
            if (a.get(i) != b.get(i)) {
                throw new AssertionError((Object)("Lists differ at index " + i + ": " + String.valueOf(a.get(i)) + " != " + String.valueOf(b.get(i))));
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class ParticleTextureNode
    extends SortableNode<ParticleTextureNode> {
        final class_2960 id;
        final class_3999 textureSheet;

        private ParticleTextureNode(class_2960 id, class_3999 textureSheet) {
            this.id = id;
            this.textureSheet = textureSheet;
        }

        private ParticleTextureNode(class_3999 textureSheet) {
            this.id = ParticleRendererRegistry.getId(textureSheet);
            this.textureSheet = textureSheet;
        }

        protected String getDescription() {
            return this.id.toString();
        }
    }
}

