/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.object.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.fabricmc.fabric.api.event.registry.RegistryIdRemapCallback;
import net.fabricmc.fabric.mixin.object.builder.EntityDataSerializersAccessor;
import net.minecraft.core.Registry;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.CrudeIncrementalIntIdentityHashBiMap;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FabricTrackedDataRegistryImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(FabricTrackedDataRegistryImpl.class);
    private static final Identifier HANDLER_REGISTRY_ID = Identifier.fromNamespaceAndPath((String)"fabric-object-builder-api-v1", (String)"tracked_data_handler");
    private static final ResourceKey<Registry<EntityDataSerializer<?>>> HANDLER_REGISTRY_KEY = ResourceKey.createRegistryKey((Identifier)HANDLER_REGISTRY_ID);
    private static final List<EntityDataSerializer<?>> VANILLA_HANDLERS = new ArrayList();
    private static @Nullable Registry<EntityDataSerializer<?>> handlerRegistry = null;
    private static final List<EntityDataSerializer<?>> EXTERNAL_MODDED_HANDLERS = new ArrayList();

    private FabricTrackedDataRegistryImpl() {
    }

    public static boolean hasStoredVanillaHandlers() {
        return !VANILLA_HANDLERS.isEmpty();
    }

    public static void storeVanillaHandlers() {
        if (FabricTrackedDataRegistryImpl.hasStoredVanillaHandlers()) {
            throw new IllegalStateException("Already stored vanilla handlers!");
        }
        CrudeIncrementalIntIdentityHashBiMap<EntityDataSerializer<?>> dataHandlers = EntityDataSerializersAccessor.fabric_getDataHandlers();
        for (EntityDataSerializer handler : dataHandlers) {
            VANILLA_HANDLERS.add(handler);
        }
        LOGGER.debug("Stored {} vanilla handlers", (Object)VANILLA_HANDLERS.size());
    }

    private static void storeExternalHandlers() {
        CrudeIncrementalIntIdentityHashBiMap<EntityDataSerializer<?>> dataHandlers = EntityDataSerializersAccessor.fabric_getDataHandlers();
        for (EntityDataSerializer handler : dataHandlers) {
            if (VANILLA_HANDLERS.contains(handler) || handlerRegistry != null && handlerRegistry.getKey((Object)handler) != null || EXTERNAL_MODDED_HANDLERS.contains(handler)) continue;
            EXTERNAL_MODDED_HANDLERS.add(handler);
            LOGGER.warn("Tracked data handler {} is not managed by vanilla or Fabric API; it may be prone to desynchronization!", (Object)handler);
        }
    }

    private static void reorderHandlers() {
        CrudeIncrementalIntIdentityHashBiMap<EntityDataSerializer<?>> dataHandlers = EntityDataSerializersAccessor.fabric_getDataHandlers();
        LOGGER.debug("Reordering tracked data handlers containing {} entries", (Object)dataHandlers.size());
        dataHandlers.clear();
        for (EntityDataSerializer<?> handler : VANILLA_HANDLERS) {
            dataHandlers.add(handler);
        }
        if (handlerRegistry != null) {
            for (EntityDataSerializer<?> handler : handlerRegistry) {
                dataHandlers.add(handler);
            }
        }
        for (EntityDataSerializer<?> handler : EXTERNAL_MODDED_HANDLERS) {
            dataHandlers.add(handler);
        }
        LOGGER.debug("Finished reordering tracked data handlers containing {} entries", (Object)dataHandlers.size());
    }

    public static void register(Identifier id, EntityDataSerializer<?> handler) {
        Objects.requireNonNull(id, "Tracked data handler ID cannot be null!");
        Objects.requireNonNull(handler, "Tracked data handler cannot be null!");
        FabricTrackedDataRegistryImpl.storeExternalHandlers();
        if (VANILLA_HANDLERS.contains(handler) || EXTERNAL_MODDED_HANDLERS.contains(handler)) {
            throw new IllegalArgumentException("Cannot register tracked data handler previously added via TrackedDataHandlerRegistry.register");
        }
        if (handlerRegistry == null) {
            handlerRegistry = FabricRegistryBuilder.createSimple(HANDLER_REGISTRY_KEY).attribute(RegistryAttribute.SYNCED).buildAndRegister();
            RegistryIdRemapCallback.event(handlerRegistry).register(state -> {
                FabricTrackedDataRegistryImpl.storeExternalHandlers();
                FabricTrackedDataRegistryImpl.reorderHandlers();
            });
        }
        Registry.register(handlerRegistry, (Identifier)id, handler);
        FabricTrackedDataRegistryImpl.reorderHandlers();
    }

    public static @Nullable EntityDataSerializer<?> get(Identifier id) {
        Objects.requireNonNull(id, "Tracked data handler ID cannot be null!");
        if (handlerRegistry == null) {
            return null;
        }
        return (EntityDataSerializer)handlerRegistry.getValue(id);
    }

    public static @Nullable Identifier getId(EntityDataSerializer<?> handler) {
        Objects.requireNonNull(handler, "Tracked data handler cannot be null!");
        if (handlerRegistry == null) {
            return null;
        }
        return handlerRegistry.getKey(handler);
    }
}

