/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.object.builder.v1.entity;

import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jspecify.annotations.Nullable;

@Deprecated
public class FabricEntityTypeBuilder<T extends Entity> {
    private MobCategory spawnGroup;
    private EntityType.EntityFactory<T> factory;
    private boolean saveable = true;
    private boolean summonable = true;
    private int trackRange = 5;
    private int trackedUpdateRate = 3;
    private Boolean forceTrackedVelocityUpdates;
    private boolean fireImmune = false;
    private boolean spawnableFarFromPlayer;
    private EntityDimensions dimensions = EntityDimensions.scalable((float)-1.0f, (float)-1.0f);
    private ImmutableSet<Block> specificSpawnBlocks = ImmutableSet.of();
    private @Nullable FeatureFlag[] requiredFeatures = null;

    protected FabricEntityTypeBuilder(MobCategory spawnGroup, EntityType.EntityFactory<T> factory) {
        this.spawnGroup = spawnGroup;
        this.factory = factory;
        this.spawnableFarFromPlayer = spawnGroup == MobCategory.CREATURE || spawnGroup == MobCategory.MISC;
    }

    @Deprecated
    public static <T extends Entity> FabricEntityTypeBuilder<T> create() {
        return FabricEntityTypeBuilder.create(MobCategory.MISC);
    }

    @Deprecated
    public static <T extends Entity> FabricEntityTypeBuilder<T> create(MobCategory spawnGroup) {
        return FabricEntityTypeBuilder.create(spawnGroup, FabricEntityTypeBuilder::emptyFactory);
    }

    @Deprecated
    public static <T extends Entity> FabricEntityTypeBuilder<T> create(MobCategory spawnGroup, EntityType.EntityFactory<T> factory) {
        return new FabricEntityTypeBuilder<T>(spawnGroup, factory);
    }

    @Deprecated
    public static <T extends LivingEntity> Living<T> createLiving() {
        return new Living(MobCategory.MISC, FabricEntityTypeBuilder::emptyFactory);
    }

    public static <T extends net.minecraft.world.entity.Mob> Mob<T> createMob() {
        return new Mob(MobCategory.MISC, FabricEntityTypeBuilder::emptyFactory);
    }

    private static <T extends Entity> T emptyFactory(EntityType<T> type, Level world) {
        return null;
    }

    @Deprecated
    public FabricEntityTypeBuilder<T> spawnGroup(MobCategory group) {
        Objects.requireNonNull(group, "Spawn group cannot be null");
        this.spawnGroup = group;
        return this;
    }

    @Deprecated
    public <N extends T> FabricEntityTypeBuilder<N> entityFactory(EntityType.EntityFactory<N> factory) {
        Objects.requireNonNull(factory, "Entity Factory cannot be null");
        this.factory = factory;
        return this;
    }

    @Deprecated
    public FabricEntityTypeBuilder<T> disableSummon() {
        this.summonable = false;
        return this;
    }

    @Deprecated
    public FabricEntityTypeBuilder<T> disableSaving() {
        this.saveable = false;
        return this;
    }

    @Deprecated
    public FabricEntityTypeBuilder<T> fireImmune() {
        this.fireImmune = true;
        return this;
    }

    @Deprecated
    public FabricEntityTypeBuilder<T> spawnableFarFromPlayer() {
        this.spawnableFarFromPlayer = true;
        return this;
    }

    @Deprecated
    public FabricEntityTypeBuilder<T> dimensions(EntityDimensions dimensions) {
        Objects.requireNonNull(dimensions, "Cannot set null dimensions");
        this.dimensions = dimensions;
        return this;
    }

    @Deprecated
    public FabricEntityTypeBuilder<T> trackable(int trackRangeBlocks, int trackedUpdateRate) {
        return this.trackable(trackRangeBlocks, trackedUpdateRate, true);
    }

    @Deprecated
    public FabricEntityTypeBuilder<T> trackable(int trackRangeBlocks, int trackedUpdateRate, boolean forceTrackedVelocityUpdates) {
        this.trackRangeBlocks(trackRangeBlocks);
        this.trackedUpdateRate(trackedUpdateRate);
        this.forceTrackedVelocityUpdates(forceTrackedVelocityUpdates);
        return this;
    }

    @Deprecated
    public FabricEntityTypeBuilder<T> trackRangeChunks(int range) {
        this.trackRange = range;
        return this;
    }

    @Deprecated
    public FabricEntityTypeBuilder<T> trackRangeBlocks(int range) {
        return this.trackRangeChunks((range + 15) / 16);
    }

    @Deprecated
    public FabricEntityTypeBuilder<T> trackedUpdateRate(int rate) {
        this.trackedUpdateRate = rate;
        return this;
    }

    @Deprecated
    public FabricEntityTypeBuilder<T> forceTrackedVelocityUpdates(boolean forceTrackedVelocityUpdates) {
        this.forceTrackedVelocityUpdates = forceTrackedVelocityUpdates;
        return this;
    }

    @Deprecated
    public FabricEntityTypeBuilder<T> specificSpawnBlocks(Block ... blocks) {
        this.specificSpawnBlocks = ImmutableSet.copyOf((Object[])blocks);
        return this;
    }

    @Deprecated
    public FabricEntityTypeBuilder<T> requires(FeatureFlag ... requiredFeatures) {
        this.requiredFeatures = requiredFeatures;
        return this;
    }

    @Deprecated
    public EntityType<T> build(ResourceKey<EntityType<?>> key) {
        EntityType.Builder builder = EntityType.Builder.of(this.factory, (MobCategory)this.spawnGroup).immuneTo((Block[])this.specificSpawnBlocks.toArray(Block[]::new)).clientTrackingRange(this.trackRange).updateInterval(this.trackedUpdateRate).sized(this.dimensions.width(), this.dimensions.height());
        if (!this.saveable) {
            builder = builder.noSave();
        }
        if (!this.summonable) {
            builder = builder.noSummon();
        }
        if (this.fireImmune) {
            builder = builder.fireImmune();
        }
        if (this.spawnableFarFromPlayer) {
            builder = builder.canSpawnFarFromPlayer();
        }
        if (this.requiredFeatures != null) {
            builder = builder.requiredFeatures(this.requiredFeatures);
        }
        if (this.forceTrackedVelocityUpdates != null) {
            builder = builder.alwaysUpdateVelocity(this.forceTrackedVelocityUpdates.booleanValue());
        }
        return builder.build(key);
    }

    @Deprecated
    public static class Living<T extends LivingEntity>
    extends FabricEntityTypeBuilder<T> {
        private @Nullable Supplier<// Could not load outer class - annotation placement on inner may be incorrect
        AttributeSupplier.Builder> defaultAttributeBuilder;

        protected Living(MobCategory spawnGroup, EntityType.EntityFactory<T> function) {
            super(spawnGroup, function);
        }

        @Override
        public Living<T> spawnGroup(MobCategory group) {
            super.spawnGroup(group);
            return this;
        }

        @Override
        public <N extends T> Living<N> entityFactory(EntityType.EntityFactory<N> factory) {
            super.entityFactory(factory);
            return this;
        }

        @Override
        public Living<T> disableSummon() {
            super.disableSummon();
            return this;
        }

        @Override
        public Living<T> disableSaving() {
            super.disableSaving();
            return this;
        }

        @Override
        public Living<T> fireImmune() {
            super.fireImmune();
            return this;
        }

        @Override
        public Living<T> spawnableFarFromPlayer() {
            super.spawnableFarFromPlayer();
            return this;
        }

        @Override
        public Living<T> dimensions(EntityDimensions dimensions) {
            super.dimensions(dimensions);
            return this;
        }

        @Override
        @Deprecated
        public Living<T> trackable(int trackRangeBlocks, int trackedUpdateRate) {
            super.trackable(trackRangeBlocks, trackedUpdateRate);
            return this;
        }

        @Override
        @Deprecated
        public Living<T> trackable(int trackRangeBlocks, int trackedUpdateRate, boolean forceTrackedVelocityUpdates) {
            super.trackable(trackRangeBlocks, trackedUpdateRate, forceTrackedVelocityUpdates);
            return this;
        }

        @Override
        public Living<T> trackRangeChunks(int range) {
            super.trackRangeChunks(range);
            return this;
        }

        @Override
        public Living<T> trackRangeBlocks(int range) {
            super.trackRangeBlocks(range);
            return this;
        }

        @Override
        public Living<T> trackedUpdateRate(int rate) {
            super.trackedUpdateRate(rate);
            return this;
        }

        @Override
        public Living<T> forceTrackedVelocityUpdates(boolean forceTrackedVelocityUpdates) {
            super.forceTrackedVelocityUpdates(forceTrackedVelocityUpdates);
            return this;
        }

        @Override
        public Living<T> specificSpawnBlocks(Block ... blocks) {
            super.specificSpawnBlocks(blocks);
            return this;
        }

        @Deprecated
        public Living<T> defaultAttributes(Supplier<AttributeSupplier.Builder> defaultAttributeBuilder) {
            Objects.requireNonNull(defaultAttributeBuilder, "Cannot set null attribute builder");
            this.defaultAttributeBuilder = defaultAttributeBuilder;
            return this;
        }

        @Override
        @Deprecated
        public EntityType<T> build(ResourceKey<EntityType<?>> key) {
            EntityType type = super.build(key);
            if (this.defaultAttributeBuilder != null) {
                FabricDefaultAttributeRegistry.register(type, this.defaultAttributeBuilder.get());
            }
            return type;
        }
    }

    @Deprecated
    public static class Mob<T extends net.minecraft.world.entity.Mob>
    extends Living<T> {
        private SpawnPlacementType spawnLocation;
        private Heightmap.Types restrictionHeightmap;
        private SpawnPlacements.SpawnPredicate<T> spawnPredicate;

        protected Mob(MobCategory spawnGroup, EntityType.EntityFactory<T> function) {
            super(spawnGroup, function);
        }

        @Override
        public Mob<T> spawnGroup(MobCategory group) {
            super.spawnGroup(group);
            return this;
        }

        @Override
        public <N extends T> Mob<N> entityFactory(EntityType.EntityFactory<N> factory) {
            super.entityFactory((EntityType.EntityFactory)factory);
            return this;
        }

        @Override
        public Mob<T> disableSummon() {
            super.disableSummon();
            return this;
        }

        @Override
        public Mob<T> disableSaving() {
            super.disableSaving();
            return this;
        }

        @Override
        public Mob<T> fireImmune() {
            super.fireImmune();
            return this;
        }

        @Override
        public Mob<T> spawnableFarFromPlayer() {
            super.spawnableFarFromPlayer();
            return this;
        }

        @Override
        public Mob<T> dimensions(EntityDimensions dimensions) {
            super.dimensions(dimensions);
            return this;
        }

        @Override
        @Deprecated
        public Mob<T> trackable(int trackRangeBlocks, int trackedUpdateRate) {
            super.trackable(trackRangeBlocks, trackedUpdateRate);
            return this;
        }

        @Override
        @Deprecated
        public Mob<T> trackable(int trackRangeBlocks, int trackedUpdateRate, boolean forceTrackedVelocityUpdates) {
            super.trackable(trackRangeBlocks, trackedUpdateRate, forceTrackedVelocityUpdates);
            return this;
        }

        @Override
        public Mob<T> trackRangeChunks(int range) {
            super.trackRangeChunks(range);
            return this;
        }

        @Override
        public Mob<T> trackRangeBlocks(int range) {
            super.trackRangeBlocks(range);
            return this;
        }

        @Override
        public Mob<T> trackedUpdateRate(int rate) {
            super.trackedUpdateRate(rate);
            return this;
        }

        @Override
        public Mob<T> forceTrackedVelocityUpdates(boolean forceTrackedVelocityUpdates) {
            super.forceTrackedVelocityUpdates(forceTrackedVelocityUpdates);
            return this;
        }

        @Override
        public Mob<T> specificSpawnBlocks(Block ... blocks) {
            super.specificSpawnBlocks(blocks);
            return this;
        }

        @Override
        public Mob<T> defaultAttributes(Supplier<AttributeSupplier.Builder> defaultAttributeBuilder) {
            super.defaultAttributes(defaultAttributeBuilder);
            return this;
        }

        @Deprecated
        public Mob<T> spawnRestriction(SpawnPlacementType spawnLocation, Heightmap.Types heightmap, SpawnPlacements.SpawnPredicate<T> spawnPredicate) {
            this.spawnLocation = Objects.requireNonNull(spawnLocation, "Spawn location cannot be null.");
            this.restrictionHeightmap = Objects.requireNonNull(heightmap, "Heightmap type cannot be null.");
            this.spawnPredicate = Objects.requireNonNull(spawnPredicate, "Spawn predicate cannot be null.");
            return this;
        }

        @Override
        public EntityType<T> build(ResourceKey<EntityType<?>> key) {
            EntityType type = super.build(key);
            if (this.spawnPredicate != null) {
                SpawnPlacements.register(type, (SpawnPlacementType)this.spawnLocation, (Heightmap.Types)this.restrictionHeightmap, this.spawnPredicate);
            }
            return type;
        }
    }
}

