/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.object.builder.v1.entity;

import org.jspecify.annotations.Nullable;
import net.fabricmc.fabric.impl.object.builder.FabricTrackedDataRegistryImpl;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2960;

/**
 * Allows registering custom {@link class_2941}s in a reliable way.
 */
public final class FabricTrackedDataRegistry {
	private FabricTrackedDataRegistry() {
	}

	/**
	 * Registers a {@link class_2941} using the given ID. Use this instead of
	 * {@link class_2943#method_12720(class_2941)} as the vanilla method exclusively uses integer
	 * IDs, which can result in desyncs and errors with custom handlers. This method is guaranteed to work reliably.
	 *
	 * <p>Handlers registered with this method will have an associated integer ID as well, which can be used with
	 * {@link class_2943#method_12721(int)} and {@link class_2943#method_12719(class_2941)}.
	 * However, the integer ID of a given custom handler registered through this method may change on registry sync.
	 * The integer IDs of vanilla handlers are guaranteed to remain constant.
	 */
	public static void register(class_2960 id, class_2941<?> handler) {
		FabricTrackedDataRegistryImpl.register(id, handler);
	}

	/**
	 * Retrieves the handler for the given ID, or {@code null} if it does not exist.
	 */
	@Nullable
	public static class_2941<?> get(class_2960 id) {
		return FabricTrackedDataRegistryImpl.get(id);
	}

	/**
	 * Retrieves the ID for the given handler, or {@code null} if the handler was not registered with
	 * {@link #register(class_2960, class_2941)}.
	 */
	@Nullable
	public static class_2960 getId(class_2941<?> handler) {
		return FabricTrackedDataRegistryImpl.getId(handler);
	}
}
