/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking.server;

import io.netty.channel.ChannelFutureListener;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.S2CConfigurationChannelEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.impl.networking.AbstractChanneledNetworkAddon;
import net.fabricmc.fabric.impl.networking.ChannelInfoHolder;
import net.fabricmc.fabric.impl.networking.NetworkingImpl;
import net.fabricmc.fabric.impl.networking.RegistrationPayload;
import net.fabricmc.fabric.impl.networking.server.ServerNetworkingImpl;
import net.fabricmc.fabric.mixin.networking.accessor.ServerCommonPacketListenerImplAccessor;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundPingPacket;
import net.minecraft.network.protocol.common.custom.BrandPayload;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import org.jspecify.annotations.Nullable;

public final class ServerConfigurationNetworkAddon
extends AbstractChanneledNetworkAddon<ServerConfigurationNetworking.ConfigurationPacketHandler<?>> {
    private final ServerConfigurationPacketListenerImpl handler;
    private final MinecraftServer server;
    private final ServerConfigurationNetworking.Context context;
    private RegisterState registerState = RegisterState.NOT_SENT;
    private @Nullable String clientBrand = null;
    private boolean isReconfiguring = false;

    public ServerConfigurationNetworkAddon(ServerConfigurationPacketListenerImpl handler, MinecraftServer server) {
        super(ServerNetworkingImpl.CONFIGURATION, ((ServerCommonPacketListenerImplAccessor)handler).getConnection(), "ServerConfigurationNetworkAddon for " + handler.getOwner().name());
        this.handler = handler;
        this.server = server;
        this.context = new ContextImpl(server, handler, this);
        this.registerPendingChannels((ChannelInfoHolder)this.connection, ConnectionProtocol.CONFIGURATION);
    }

    @Override
    public boolean handle(CustomPacketPayload payload) {
        if (payload instanceof BrandPayload) {
            BrandPayload brandCustomPayload = (BrandPayload)payload;
            this.clientBrand = brandCustomPayload.brand();
            return false;
        }
        return super.handle(payload);
    }

    @Override
    protected boolean isOnReceiveThread() {
        return true;
    }

    @Override
    protected void invokeInitEvent() {
    }

    public void preConfiguration() {
        ((ServerConfigurationConnectionEvents.Configure)ServerConfigurationConnectionEvents.BEFORE_CONFIGURE.invoker()).onSendConfiguration(this.handler, this.server);
    }

    public void configuration() {
        ((ServerConfigurationConnectionEvents.Configure)ServerConfigurationConnectionEvents.CONFIGURE.invoker()).onSendConfiguration(this.handler, this.server);
    }

    public boolean startConfiguration() {
        if (this.registerState == RegisterState.NOT_SENT) {
            this.sendInitialChannelRegistrationPacket();
            this.sendPacket((Packet<?>)new ClientboundPingPacket(16430876));
            this.registerState = RegisterState.SENT;
            return true;
        }
        if (this.registerState != RegisterState.RECEIVED && this.registerState != RegisterState.NOT_RECEIVED) {
            throw new IllegalStateException();
        }
        return false;
    }

    @Override
    protected void receiveRegistration(boolean register, RegistrationPayload resolvable) {
        super.receiveRegistration(register, resolvable);
        if (register && this.registerState == RegisterState.SENT) {
            this.registerState = RegisterState.RECEIVED;
            this.handler.startConfiguration();
        }
    }

    public void onPong(int parameter) {
        if (this.registerState == RegisterState.SENT) {
            this.registerState = RegisterState.NOT_RECEIVED;
            this.handler.startConfiguration();
        }
    }

    @Override
    protected void receive(ServerConfigurationNetworking.ConfigurationPacketHandler<?> handler, CustomPacketPayload payload) {
        handler.receive(payload, this.context);
    }

    @Override
    protected void schedule(Runnable task) {
        this.server.execute(task);
    }

    @Override
    public Packet<?> createPacket(CustomPacketPayload packet) {
        return ServerConfigurationNetworking.createS2CPacket(packet);
    }

    @Override
    protected void invokeRegisterEvent(List<Identifier> ids) {
        ((S2CConfigurationChannelEvents.Register)S2CConfigurationChannelEvents.REGISTER.invoker()).onChannelRegister(this.handler, this, this.server, ids);
    }

    @Override
    protected void invokeUnregisterEvent(List<Identifier> ids) {
        ((S2CConfigurationChannelEvents.Unregister)S2CConfigurationChannelEvents.UNREGISTER.invoker()).onChannelUnregister(this.handler, this, this.server, ids);
    }

    @Override
    protected void handleRegistration(Identifier channelName) {
        RegistrationPayload registrationPayload;
        if (this.registerState != RegisterState.NOT_SENT && (registrationPayload = this.createRegistrationPayload(RegistrationPayload.REGISTER, Collections.singleton(channelName))) != null) {
            this.sendPacket(registrationPayload);
        }
    }

    @Override
    protected void handleUnregistration(Identifier channelName) {
        RegistrationPayload registrationPayload;
        if (this.registerState != RegisterState.NOT_SENT && (registrationPayload = this.createRegistrationPayload(RegistrationPayload.UNREGISTER, Collections.singleton(channelName))) != null) {
            this.sendPacket(registrationPayload);
        }
    }

    @Override
    protected void invokeDisconnectEvent() {
        ((ServerConfigurationConnectionEvents.Disconnect)ServerConfigurationConnectionEvents.DISCONNECT.invoker()).onConfigureDisconnect(this.handler, this.server);
    }

    @Override
    protected boolean isReservedChannel(Identifier channelName) {
        return NetworkingImpl.isReservedCommonChannel(channelName);
    }

    @Override
    public void sendPacket(Packet<?> packet, ChannelFutureListener callback) {
        this.handler.send(packet, callback);
    }

    public @Nullable String getClientBrand() {
        return this.clientBrand;
    }

    public boolean isReconfiguring() {
        return this.isReconfiguring;
    }

    public void setReconfiguring() {
        this.isReconfiguring = true;
    }

    public ChannelInfoHolder getChannelInfoHolder() {
        return (ChannelInfoHolder)((ServerCommonPacketListenerImplAccessor)this.handler).getConnection();
    }

    private static enum RegisterState {
        NOT_SENT,
        SENT,
        RECEIVED,
        NOT_RECEIVED;

    }

    private record ContextImpl(MinecraftServer server, ServerConfigurationPacketListenerImpl networkHandler, PacketSender responseSender) implements ServerConfigurationNetworking.Context
    {
        private ContextImpl {
            Objects.requireNonNull(server, "server");
            Objects.requireNonNull(networkHandler, "networkHandler");
            Objects.requireNonNull(responseSender, "responseSender");
        }
    }
}

