/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.networking.splitter;

import io.netty.buffer.ByteBuf;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public record FabricSplitPacketPayload(ByteBuf byteBuf) implements class_8710 {
	public static final class_9154<FabricSplitPacketPayload> ID = new class_9154<>(class_2960.method_60655("fabric", "split"));
	public static final class_9139<ByteBuf, FabricSplitPacketPayload> CODEC = class_9139.method_56437(FabricSplitPacketPayload::write, FabricSplitPacketPayload::read);

	private static FabricSplitPacketPayload read(ByteBuf buf) {
		return new FabricSplitPacketPayload(buf.readBytes(buf.readableBytes()));
	}

	private static void write(ByteBuf buf, FabricSplitPacketPayload payload) {
		buf.writeBytes(payload.byteBuf());
	}

	@Override
	public class_9154<? extends class_8710> method_56479() {
		return ID;
	}
}
