/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.model.loading;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.model.loading.v1.CompositeBlockStateModel;
import net.fabricmc.fabric.api.client.renderer.v1.mesh.QuadEmitter;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.UnmodifiableView;
import org.jspecify.annotations.Nullable;

public class CompositeBlockStateModelImpl
implements CompositeBlockStateModel {
    private final BlockStateModel[] models;
    private final @UnmodifiableView List<BlockStateModel> modelsView;

    public CompositeBlockStateModelImpl(BlockStateModel[] models) {
        this.models = models;
        this.modelsView = Arrays.asList(models);
    }

    public static CompositeBlockStateModelImpl of(List<BlockStateModel> models) {
        if (models.isEmpty()) {
            throw new IllegalArgumentException("Models list must not be empty");
        }
        for (BlockStateModel model : models) {
            Objects.requireNonNull(model, "Model cannot be null");
        }
        return new CompositeBlockStateModelImpl((BlockStateModel[])models.toArray(BlockStateModel[]::new));
    }

    @Override
    public @Unmodifiable List<BlockStateModel> models() {
        return this.modelsView;
    }

    public void collectParts(RandomSource random, List<BlockModelPart> parts) {
        long seed = random.nextLong();
        for (BlockStateModel model : this.models) {
            random.setSeed(seed);
            model.collectParts(random, parts);
        }
    }

    public void emitQuads(QuadEmitter emitter, BlockAndTintGetter level, BlockPos pos, BlockState state, RandomSource random, Predicate<@Nullable Direction> cullTest) {
        long seed = random.nextLong();
        for (BlockStateModel model : this.models) {
            random.setSeed(seed);
            model.emitQuads(emitter, level, pos, state, random, cullTest);
        }
    }

    public @Nullable Object createGeometryKey(BlockAndTintGetter level, BlockPos pos, BlockState state, RandomSource random) {
        int count = this.models.length;
        long seed = random.nextLong();
        if (count == 1) {
            random.setSeed(seed);
            return this.models[0].createGeometryKey(level, pos, state, random);
        }
        ArrayList<Object> subkeys = new ArrayList<Object>(count);
        for (BlockStateModel submodel : this.models) {
            random.setSeed(seed);
            Object subkey = submodel.createGeometryKey(level, pos, state, random);
            if (subkey == null) {
                return null;
            }
            subkeys.add(subkey);
        }
        record Key(List<Object> subkeys) {
        }
        return new Key(subkeys);
    }

    public TextureAtlasSprite particleIcon() {
        return this.models[0].particleIcon();
    }

    public TextureAtlasSprite particleIcon(BlockAndTintGetter level, BlockPos pos, BlockState state) {
        return this.models[0].particleIcon(level, pos, state);
    }

    public record Unbaked(@Unmodifiable List<// Could not load outer class - annotation placement on inner may be incorrect
    BlockStateModel.Unbaked> models) implements CompositeBlockStateModel.Unbaked
    {
        public static final MapCodec<Unbaked> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.nonEmptyList((Codec)BlockStateModel.Unbaked.CODEC.listOf()).fieldOf("models").forGetter(Unbaked::models)).apply((Applicative)instance, Unbaked::new));

        public static Unbaked of(List<BlockStateModel.Unbaked> models) {
            if (models.isEmpty()) {
                throw new IllegalArgumentException("Models list must not be empty");
            }
            for (BlockStateModel.Unbaked model : models) {
                Objects.requireNonNull(model, "Model cannot be null");
            }
            return new Unbaked(List.copyOf(models));
        }

        public MapCodec<Unbaked> codec() {
            return CODEC;
        }

        public BlockStateModel bake(ModelBaker baker) {
            BlockStateModel[] bakedModels = new BlockStateModel[this.models.size()];
            for (int i = 0; i < this.models.size(); ++i) {
                bakedModels[i] = this.models.get(i).bake(baker);
            }
            return new CompositeBlockStateModelImpl(bakedModels);
        }

        public void resolveDependencies(ResolvableModel.Resolver resolver) {
            this.models.forEach(model -> model.resolveDependencies(resolver));
        }
    }
}

