/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.model.loading;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.loading.v1.UnbakedModelDeserializer;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_793;

@Environment(value=EnvType.CLIENT)
public class UnbakedModelJsonDeserializer
implements JsonDeserializer<class_1100> {
    private static final String TYPE_KEY = "fabric:type";
    private static final String TYPE_ID_KEY = "id";
    private static final String TYPE_OPTIONAL_KEY = "optional";

    public class_1100 deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (jsonObject.has(TYPE_KEY)) {
            boolean optional;
            String idStr;
            JsonElement typeElement = jsonObject.get(TYPE_KEY);
            if (typeElement.isJsonPrimitive()) {
                idStr = typeElement.getAsString();
                optional = false;
            } else if (typeElement.isJsonObject()) {
                JsonObject typeObject = typeElement.getAsJsonObject();
                idStr = class_3518.method_15265((JsonObject)typeObject, (String)TYPE_ID_KEY);
                optional = class_3518.method_15258((JsonObject)typeObject, (String)TYPE_OPTIONAL_KEY, (boolean)false);
            } else {
                throw new JsonSyntaxException("Expected fabric:type to be a string or object, was " + class_3518.method_15266((JsonElement)typeElement));
            }
            class_2960 id = class_2960.method_60654((String)idStr);
            UnbakedModelDeserializer deserializer = UnbakedModelDeserializer.get(id);
            if (deserializer != null) {
                return deserializer.deserialize(jsonObject, context);
            }
            if (!optional) {
                throw new JsonParseException("Cannot deserialize custom unbaked model of unknown type '" + String.valueOf(id) + "'");
            }
        }
        return (class_1100)context.deserialize(jsonElement, class_793.class);
    }
}

