/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.client.model.loading;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.api.client.model.loading.v1.ExtraModelKey;
import net.fabricmc.fabric.impl.client.model.loading.BakedModelsHooks;
import net.fabricmc.fabric.impl.client.model.loading.ModelLoadingEventDispatcher;
import net.minecraft.class_10439;
import net.minecraft.class_10769;
import net.minecraft.class_10819;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7775;

@Mixin(class_1088.class)
abstract class ModelBakeryMixin {
	@Shadow
	@Final
	static Logger LOGGER;

	@Shadow
	@Final
	Map<class_2960, class_10819> resolvedModels;

	@Unique
	@Nullable
	private ModelLoadingEventDispatcher fabric_eventDispatcher;

	@Inject(method = "<init>", at = @At("RETURN"))
	private void onReturnInit(CallbackInfo ci) {
		fabric_eventDispatcher = ModelLoadingEventDispatcher.CURRENT.get();
	}

	@ModifyArg(method = "bakeModels", at = @At(value = "INVOKE", target = "Lnet/minecraft/util/thread/ParallelMapTransform;schedule(Ljava/util/Map;Ljava/util/function/BiFunction;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;", ordinal = 0), index = 1)
	private BiFunction<class_2680, class_1087.class_9979, class_1087> hookBlockModelBake(BiFunction<class_2680, class_1087.class_9979, class_1087> bifunction) {
		if (fabric_eventDispatcher == null) {
			return bifunction;
		}

		return (state, unbakedModel) -> {
			ModelLoadingEventDispatcher.CURRENT.set(fabric_eventDispatcher);
			class_1087 model = bifunction.apply(state, unbakedModel);
			ModelLoadingEventDispatcher.CURRENT.remove();
			return model;
		};
	}

	@ModifyReturnValue(method = "bakeModels", at = @At("RETURN"))
	private CompletableFuture<class_1088.class_10524> withExtraModels(CompletableFuture<class_1088.class_10524> models, @Local Executor executor, @Local class_1088.class_7778 baker) {
		if (fabric_eventDispatcher == null) return models;

		CompletableFuture<Map<ExtraModelKey<?>, Object>> extraModels = class_10769.method_67612(fabric_eventDispatcher.getExtraModels(), (key, model) -> {
			try {
				return model.bake(baker);
			} catch (Exception e) {
				LOGGER.warn("Unable to bake extra model: '{}'", key, e);
				return null;
			}
		}, executor);
		return models.thenCombine(extraModels, (res, extra) -> {
			((BakedModelsHooks) (Object) res).fabric_setExtraModels(extra);
			return res;
		});
	}

	@WrapOperation(method = "method_68018", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/block/model/BlockStateModel$UnbakedRoot;bake(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/client/resources/model/ModelBaker;)Lnet/minecraft/client/renderer/block/model/BlockStateModel;"))
	private static class_1087 wrapBlockModelBake(class_1087.class_9979 unbakedModel, class_2680 state, class_7775 baker, Operation<class_1087> operation) {
		ModelLoadingEventDispatcher eventDispatcher = ModelLoadingEventDispatcher.CURRENT.get();

		if (eventDispatcher == null) {
			return operation.call(unbakedModel, state, baker);
		}

		return eventDispatcher.modifyBlockModel(unbakedModel, state, baker, operation);
	}

	@WrapOperation(method = "method_68019", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/item/ItemModel$Unbaked;bake(Lnet/minecraft/client/renderer/item/ItemModel$BakingContext;)Lnet/minecraft/client/renderer/item/ItemModel;"))
	private class_10439 wrapItemModelBake(class_10439.class_10441 unbakedModel, class_10439.class_10440 bakeContext, Operation<class_10439> operation, @Local class_2960 itemId) {
		if (fabric_eventDispatcher == null) {
			return operation.call(unbakedModel, bakeContext);
		}

		return fabric_eventDispatcher.modifyItemModel(unbakedModel, itemId, bakeContext, operation);
	}
}
