/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.client.message;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.mojang.authlib.GameProfile;
import java.time.Instant;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.client.multiplayer.chat.ChatListener;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.PlayerChatMessage;
import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChatListener.class})
public abstract class ChatListenerMixin {
    @Inject(method={"showMessageToPlayer"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/Gui;getChat()Lnet/minecraft/client/gui/components/ChatComponent;", ordinal=0)}, cancellable=true)
    private void fabric_onSignedChatMessage(ChatType.Bound params, PlayerChatMessage message, Component decorated, GameProfile sender, boolean onlyShowSecureChat, Instant receptionTimestamp, CallbackInfoReturnable<Boolean> cir) {
        this.fabric_onChatMessage(decorated, message, sender, params, receptionTimestamp, cir);
    }

    @Inject(method={"showMessageToPlayer"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/Gui;getChat()Lnet/minecraft/client/gui/components/ChatComponent;", ordinal=1)}, cancellable=true)
    private void fabric_onFilteredSignedChatMessage(ChatType.Bound params, PlayerChatMessage message, Component decorated, GameProfile sender, boolean onlyShowSecureChat, Instant receptionTimestamp, CallbackInfoReturnable<Boolean> cir) {
        Component filtered = message.filterMask().applyWithFormatting(message.signedContent());
        if (filtered != null) {
            this.fabric_onChatMessage(params.decorate(filtered), message, sender, params, receptionTimestamp, cir);
        }
    }

    @Inject(method={"lambda$handleDisguisedChatMessage$0"}, at={@At(value="HEAD")}, cancellable=true)
    private void fabric_onProfilelessChatMessage(ChatType.Bound params, Component content, Instant receptionTimestamp, CallbackInfoReturnable<Boolean> cir) {
        this.fabric_onChatMessage(params.decorate(content), null, null, params, receptionTimestamp, cir);
    }

    @Unique
    private void fabric_onChatMessage(Component message, @Nullable PlayerChatMessage signedMessage, @Nullable GameProfile sender, ChatType.Bound params, Instant receptionTimestamp, CallbackInfoReturnable<Boolean> cir) {
        if (((ClientReceiveMessageEvents.AllowChat)ClientReceiveMessageEvents.ALLOW_CHAT.invoker()).allowReceiveChatMessage(message, signedMessage, sender, params, receptionTimestamp)) {
            ((ClientReceiveMessageEvents.Chat)ClientReceiveMessageEvents.CHAT.invoker()).onReceiveChatMessage(message, signedMessage, sender, params, receptionTimestamp);
        } else {
            ((ClientReceiveMessageEvents.ChatCanceled)ClientReceiveMessageEvents.CHAT_CANCELED.invoker()).onReceiveChatMessageCanceled(message, signedMessage, sender, params, receptionTimestamp);
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"handleSystemMessage"}, at={@At(value="HEAD")}, cancellable=true)
    private void fabric_allowGameMessage(Component _message, boolean overlay, CallbackInfo ci, @Local(argsOnly=true) LocalRef<Component> message) {
        if (((ClientReceiveMessageEvents.AllowGame)ClientReceiveMessageEvents.ALLOW_GAME.invoker()).allowReceiveGameMessage((Component)message.get(), overlay)) {
            message.set((Object)((ClientReceiveMessageEvents.ModifyGame)ClientReceiveMessageEvents.MODIFY_GAME.invoker()).modifyReceivedGameMessage((Component)message.get(), overlay));
            ((ClientReceiveMessageEvents.Game)ClientReceiveMessageEvents.GAME.invoker()).onReceiveGameMessage((Component)message.get(), overlay);
        } else {
            ((ClientReceiveMessageEvents.GameCanceled)ClientReceiveMessageEvents.GAME_CANCELED.invoker()).onReceiveGameMessageCanceled((Component)message.get(), overlay);
            ci.cancel();
        }
    }
}

