/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.message;

import java.util.function.Function;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerList.class})
public abstract class PlayerListMixin {
    @Shadow
    @Final
    private MinecraftServer server;

    @Inject(method={"broadcastChatMessage(Lnet/minecraft/network/chat/PlayerChatMessage;Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/network/chat/ChatType$Bound;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSendChatMessage(PlayerChatMessage message, ServerPlayer sender, ChatType.Bound params, CallbackInfo ci) {
        if (!((ServerMessageEvents.AllowChatMessage)ServerMessageEvents.ALLOW_CHAT_MESSAGE.invoker()).allowChatMessage(message, sender, params)) {
            ci.cancel();
            return;
        }
        ((ServerMessageEvents.ChatMessage)ServerMessageEvents.CHAT_MESSAGE.invoker()).onChatMessage(message, sender, params);
    }

    @Inject(method={"broadcastSystemMessage(Lnet/minecraft/network/chat/Component;Ljava/util/function/Function;Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSendGameMessage(Component message, Function<ServerPlayer, Component> playerMessageFactory, boolean overlay, CallbackInfo ci) {
        if (!((ServerMessageEvents.AllowGameMessage)ServerMessageEvents.ALLOW_GAME_MESSAGE.invoker()).allowGameMessage(this.server, message, overlay)) {
            ci.cancel();
            return;
        }
        ((ServerMessageEvents.GameMessage)ServerMessageEvents.GAME_MESSAGE.invoker()).onGameMessage(this.server, message, overlay);
    }

    @Inject(method={"broadcastChatMessage(Lnet/minecraft/network/chat/PlayerChatMessage;Lnet/minecraft/commands/CommandSourceStack;Lnet/minecraft/network/chat/ChatType$Bound;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSendCommandMessage(PlayerChatMessage message, CommandSourceStack source, ChatType.Bound params, CallbackInfo ci) {
        if (!((ServerMessageEvents.AllowCommandMessage)ServerMessageEvents.ALLOW_COMMAND_MESSAGE.invoker()).allowCommandMessage(message, source, params)) {
            ci.cancel();
            return;
        }
        ((ServerMessageEvents.CommandMessage)ServerMessageEvents.COMMAND_MESSAGE.invoker()).onCommandMessage(message, source, params);
    }
}

