/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.event.lifecycle.v1;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;

public final class ServerTickEvents {
    public static final Event<StartTick> START_SERVER_TICK = EventFactory.createArrayBacked(StartTick.class, callbacks -> server -> {
        for (StartTick event : callbacks) {
            event.onStartTick(server);
        }
    });
    public static final Event<EndTick> END_SERVER_TICK = EventFactory.createArrayBacked(EndTick.class, callbacks -> server -> {
        for (EndTick event : callbacks) {
            event.onEndTick(server);
        }
    });
    public static final Event<StartWorldTick> START_WORLD_TICK = EventFactory.createArrayBacked(StartWorldTick.class, callbacks -> world -> {
        for (StartWorldTick callback : callbacks) {
            callback.onStartTick(world);
        }
    });
    public static final Event<EndWorldTick> END_WORLD_TICK = EventFactory.createArrayBacked(EndWorldTick.class, callbacks -> world -> {
        for (EndWorldTick callback : callbacks) {
            callback.onEndTick(world);
        }
    });

    private ServerTickEvents() {
    }

    @FunctionalInterface
    public static interface EndWorldTick {
        public void onEndTick(ServerLevel var1);
    }

    @FunctionalInterface
    public static interface StartWorldTick {
        public void onStartTick(ServerLevel var1);
    }

    @FunctionalInterface
    public static interface EndTick {
        public void onEndTick(MinecraftServer var1);
    }

    @FunctionalInterface
    public static interface StartTick {
        public void onStartTick(MinecraftServer var1);
    }
}

