/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.item;

import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractFurnaceBlockEntity.class})
public abstract class AbstractFurnaceBlockEntityMixin {
    @Unique
    private static final ThreadLocal<ItemStack> REMAINDER_STACK = new ThreadLocal();

    @Inject(method={"serverTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getItem()Lnet/minecraft/world/item/Item;")}, allow=1)
    private static void getStackRemainder(ServerLevel world, BlockPos pos, BlockState state, AbstractFurnaceBlockEntity blockEntity, CallbackInfo ci, @Local(ordinal=0) ItemStack itemStack) {
        REMAINDER_STACK.set(itemStack.getRecipeRemainder());
    }

    @ModifyArg(method={"serverTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/NonNullList;set(ILjava/lang/Object;)Ljava/lang/Object;"), index=1, allow=1)
    private static <E> E setStackRemainder(E element) {
        ItemStack remainder = REMAINDER_STACK.get();
        REMAINDER_STACK.remove();
        return (E)remainder;
    }
}

