/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.item;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import net.fabricmc.fabric.impl.item.RecipeRemainderHandler;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3955;

@Mixin(class_3955.class)
public interface CraftingRecipeMixin {
	@WrapOperation(method = "defaultCraftingReminder", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;getItem()Lnet/minecraft/world/item/Item;"))
	private static class_1792 captureStack(class_1799 stack, Operation<class_1792> operation) {
		RecipeRemainderHandler.REMAINDER_STACK.set(stack.getRecipeRemainder());
		return operation.call(stack);
	}

	@Redirect(method = "defaultCraftingReminder", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/Item;getCraftingRemainder()Lnet/minecraft/world/item/ItemStack;"))
	private static class_1799 getStackRemainder(class_1792 item) {
		class_1799 remainder = RecipeRemainderHandler.REMAINDER_STACK.get();
		RecipeRemainderHandler.REMAINDER_STACK.remove();
		return remainder;
	}
}
