/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.item;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_9299;
import net.minecraft.class_9331;

public final class ComponentTooltipAppenderRegistryImpl {
	private static final List<class_9331<? extends class_9299>> first = new ArrayList<>();
	private static final List<class_9331<? extends class_9299>> last = new ArrayList<>();
	private static final Map<class_9331<?>, List<class_9331<? extends class_9299>>> before = new IdentityHashMap<>();
	private static final Map<class_9331<?>, List<class_9331<? extends class_9299>>> after = new IdentityHashMap<>();
	private static boolean hasModdedEntries = false;

	public static void addFirst(class_9331<? extends class_9299> componentType) {
		first.add(componentType);
		onModified();
	}

	public static void addLast(class_9331<? extends class_9299> componentType) {
		last.add(componentType);
		onModified();
	}

	public static void addBefore(class_9331<?> anchor, class_9331<? extends class_9299> componentType) {
		before.computeIfAbsent(anchor, k -> new ArrayList<>()).add(componentType);
		onModified();
	}

	public static void addAfter(class_9331<?> anchor, class_9331<? extends class_9299> componentType) {
		after.computeIfAbsent(anchor, k -> new ArrayList<>()).add(componentType);
		onModified();
	}

	private static void onModified() {
		hasModdedEntries = true;
		VanillaTooltipAppenderOrder.load();
	}

	public static boolean hasModdedEntries() {
		return hasModdedEntries;
	}

	public static void onFirst(
			class_1799 stack,
			class_1792.class_9635 context,
			class_10712 displayComponent,
			Consumer<class_2561> textConsumer,
			class_1836 type
	) {
		Set<class_9331<?>> cycleDetector = new HashSet<>();

		for (class_9331<? extends class_9299> componentType : first) {
			appendCustomComponentTooltip(stack, componentType, context, displayComponent, textConsumer, type, cycleDetector);
		}
	}

	public static void onLast(
			class_1799 stack,
			class_1792.class_9635 context,
			class_10712 displayComponent,
			Consumer<class_2561> textConsumer,
			class_1836 type
	) {
		Set<class_9331<?>> cycleDetector = new HashSet<>();

		for (class_9331<? extends class_9299> componentType : last) {
			appendCustomComponentTooltip(stack, componentType, context, displayComponent, textConsumer, type, cycleDetector);
		}
	}

	public static void onBefore(
			class_1799 stack,
			class_9331<?> componentType,
			class_1792.class_9635 context,
			class_10712 displayComponent,
			Consumer<class_2561> textConsumer,
			class_1836 type,
			Set<class_9331<?>> cycleDetector
	) {
		List<class_9331<? extends class_9299>> befores = before.get(componentType);

		if (befores != null) {
			for (class_9331<? extends class_9299> beforeComponentType : befores) {
				appendCustomComponentTooltip(stack, beforeComponentType, context, displayComponent, textConsumer, type, cycleDetector);
			}
		}
	}

	public static void onAfter(
			class_1799 stack,
			class_9331<?> componentType,
			class_1792.class_9635 context,
			class_10712 displayComponent,
			Consumer<class_2561> textConsumer,
			class_1836 type,
			Set<class_9331<?>> cycleDetector
	) {
		List<class_9331<? extends class_9299>> afters = after.get(componentType);

		if (afters != null) {
			for (class_9331<? extends class_9299> afterComponentType : afters) {
				appendCustomComponentTooltip(stack, afterComponentType, context, displayComponent, textConsumer, type, cycleDetector);
			}
		}
	}

	private static void appendCustomComponentTooltip(
			class_1799 stack,
			class_9331<? extends class_9299> componentType,
			class_1792.class_9635 context,
			class_10712 displayComponent,
			Consumer<class_2561> textConsumer,
			class_1836 type,
			Set<class_9331<?>> cycleDetector
	) {
		if (!cycleDetector.add(componentType)) {
			return;
		}

		onBefore(stack, componentType, context, displayComponent, textConsumer, type, cycleDetector);
		stack.method_57369(componentType, context, displayComponent, textConsumer, type);
		onAfter(stack, componentType, context, displayComponent, textConsumer, type, cycleDetector);

		cycleDetector.remove(componentType);
	}
}
