/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.gametest;

import com.google.common.collect.ImmutableList;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DataFixer;
import java.io.IOException;
import java.io.Reader;
import java.util.Optional;
import java.util.stream.Stream;
import net.fabricmc.fabric.impl.gametest.FabricGameTestRunner;
import net.minecraft.core.HolderGetter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.apache.commons.io.IOUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={StructureTemplateManager.class})
public abstract class StructureTemplateManagerMixin {
    @Shadow
    private ResourceManager resourceManager;

    @Shadow
    public abstract StructureTemplate readStructure(CompoundTag var1);

    @Unique
    private Optional<StructureTemplate> fabric_loadSnbtFromResource(Identifier id) {
        Identifier path = FabricGameTestRunner.GAMETEST_STRUCTURE_FINDER.idToFile(id);
        Optional resource = this.resourceManager.getResource(path);
        if (resource.isPresent()) {
            try {
                String snbt = IOUtils.toString((Reader)((Resource)resource.get()).openAsReader());
                CompoundTag tag = NbtUtils.snbtToStructure((String)snbt);
                return Optional.of(this.readStructure(tag));
            }
            catch (CommandSyntaxException | IOException e) {
                throw new RuntimeException("Failed to load GameTest structure " + String.valueOf(id), e);
            }
        }
        return Optional.empty();
    }

    @Unique
    private Stream<Identifier> streamTemplatesFromResource() {
        FileToIdConverter finder = FabricGameTestRunner.GAMETEST_STRUCTURE_FINDER;
        return finder.listMatchingResources(this.resourceManager).keySet().stream().map(arg_0 -> ((FileToIdConverter)finder).fileToId(arg_0));
    }

    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="Lcom/google/common/collect/ImmutableList$Builder;add(Ljava/lang/Object;)Lcom/google/common/collect/ImmutableList$Builder;", ordinal=2, shift=At.Shift.AFTER)})
    private void addFabricTemplateProvider(ResourceManager resourceManager, LevelStorageSource.LevelStorageAccess storageAccess, DataFixer dataFixer, HolderGetter<Block> blockLookup, CallbackInfo ci, @Local ImmutableList.Builder<StructureTemplateManager.Source> builder) {
        builder.add((Object)new StructureTemplateManager.Source(this::fabric_loadSnbtFromResource, this::streamTemplatesFromResource));
    }
}

