/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.gametest;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_10660;
import net.minecraft.class_10665;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_7655;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public final class FabricGameTestModInitializer implements ModInitializer {
	private static final Logger LOGGER = LoggerFactory.getLogger(FabricGameTestModInitializer.class);
	private static TestAnnotationLocator locator = new TestAnnotationLocator(FabricLoader.getInstance());

	@Override
	public void onInitialize() {
		if (!(FabricGameTestRunner.ENABLED || FabricLoader.getInstance().isDevelopmentEnvironment())) {
			// Don't try to load the tests if the game test runner is disabled or we are not in a development environment
			return;
		}

		for (TestAnnotationLocator.TestMethod testMethod : locator.getTestMethods()) {
			LOGGER.debug("Registering test method: {}", testMethod.identifier());
			class_2378.method_10230(class_7923.field_56156, testMethod.identifier(), testMethod.testFunction());
		}
	}

	public static void registerDynamicEntries(List<class_7655.class_9158<?>> registriesList) {
		Map<class_5321<? extends class_2378<?>>, class_2378<?>> registries = new IdentityHashMap<>(registriesList.size());

		for (class_7655.class_9158<?> entry : registriesList) {
			registries.put(entry.comp_2246().method_46765(), entry.comp_2246());
		}

		class_2378<class_10660> testInstances = (class_2378<class_10660>) registries.get(class_7924.field_56161);
		class_2378<class_10665> testEnvironmentDefinitionRegistry = (class_2378<class_10665>) Objects.requireNonNull(registries.get(class_7924.field_56160));

		for (TestAnnotationLocator.TestMethod testMethod : locator.getTestMethods()) {
			class_10660 testInstance = testMethod.testInstance(testEnvironmentDefinitionRegistry);
			class_2378.method_10230(testInstances, testMethod.identifier(), testInstance);
		}
	}
}
