/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.gamerule.entry;

import com.mojang.serialization.DataResult;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.mixin.gamerule.client.EditGameRulesScreenAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.worldselection.EditGameRulesScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.gamerules.GameRule;

public final class DoubleRuleEntry
extends EditGameRulesScreen.GameRuleEntry {
    private final EditBox input;

    public DoubleRuleEntry(EditGameRulesScreen gameRuleScreen, Component name, List<FormattedCharSequence> description, String ruleName, GameRule<Double> doubleRule) {
        EditGameRulesScreen editGameRulesScreen = gameRuleScreen;
        Objects.requireNonNull(editGameRulesScreen);
        super(editGameRulesScreen, description, name);
        EditGameRulesScreenAccessor accessor = (EditGameRulesScreenAccessor)gameRuleScreen;
        this.input = new EditBox(Minecraft.getInstance().font, 10, 5, 42, 20, (Component)name.copy().append(CommonComponents.NEW_LINE).append(ruleName).append(CommonComponents.NEW_LINE));
        this.input.setValue(accessor.getGameRules().getAsString(doubleRule));
        this.input.setResponder(value -> {
            DataResult dataResult = doubleRule.deserialize(value);
            if (dataResult.isSuccess()) {
                this.input.setTextColor(-2039584);
                accessor.callClearInvalid((EditGameRulesScreen.RuleEntry)this);
                accessor.getGameRules().set(doubleRule, (Object)((Double)dataResult.getOrThrow()), null);
            } else {
                this.input.setTextColor(-65536);
                accessor.callMarkInvalid((EditGameRulesScreen.RuleEntry)this);
            }
        });
        this.children.add(this.input);
    }

    public void renderContent(GuiGraphics graphics, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        this.renderLabel(graphics, this.getContentY(), this.getContentX());
        this.input.setX(this.getContentRight() - 44);
        this.input.setY(this.getContentY());
        this.input.render(graphics, mouseX, mouseY, tickDelta);
    }
}

