/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.gamerule.widget;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.fabricmc.fabric.impl.gamerule.RuleTypeExtensions;
import net.fabricmc.fabric.mixin.gamerule.client.EditGameRulesScreenAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.worldselection.EditGameRulesScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.gamerules.GameRule;

public final class EnumRuleWidget<E extends Enum<E>>
extends EditGameRulesScreen.GameRuleEntry {
    private final Button buttonWidget;
    private final String rootTranslationKey;

    public EnumRuleWidget(EditGameRulesScreen gameRuleScreen, Component name, List<FormattedCharSequence> description, String ruleName, GameRule<E> enumRule, String translationKey) {
        EditGameRulesScreen editGameRulesScreen = gameRuleScreen;
        Objects.requireNonNull(editGameRulesScreen);
        super(editGameRulesScreen, description, name);
        EditGameRulesScreenAccessor accessor = (EditGameRulesScreenAccessor)gameRuleScreen;
        this.label = Minecraft.getInstance().font.split((FormattedText)name, 131);
        this.rootTranslationKey = translationKey;
        this.buttonWidget = Button.builder((Component)this.getValueText((Enum)accessor.getGameRules().get(enumRule)), buttonWidget -> {
            accessor.getGameRules().set(enumRule, (Object)((RuleTypeExtensions)enumRule).fabric_enumCycle((Enum)accessor.getGameRules().get(enumRule)), null);
            buttonWidget.setMessage(this.getValueText((Enum)accessor.getGameRules().get(enumRule)));
        }).bounds(10, 5, 42, 20).build();
        this.children.add(this.buttonWidget);
    }

    public Component getValueText(E value) {
        String key = this.rootTranslationKey + "." + ((Enum)value).name().toLowerCase(Locale.ROOT);
        return Component.translatableWithFallback((String)key, (String)((Enum)value).toString());
    }

    public void renderContent(GuiGraphics context, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        this.renderLabel(context, this.getContentY(), this.getContentX());
        this.buttonWidget.setX(this.getContentRight() - 44);
        this.buttonWidget.setY(this.getContentY());
        this.buttonWidget.render(context, mouseX, mouseY, tickDelta);
    }
}

