/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.gamerule.widget;

import java.util.List;
import java.util.Locale;
import net.fabricmc.fabric.impl.gamerule.RuleTypeExtensions;
import net.fabricmc.fabric.mixin.gamerule.client.EditGameRulesScreenAccessor;
import net.minecraft.class_12279;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5235;
import net.minecraft.class_5481;

public final class EnumRuleWidget<E extends Enum<E>> extends class_5235.class_5400 {
	private final class_4185 buttonWidget;
	private final String rootTranslationKey;

	public EnumRuleWidget(class_5235 gameRuleScreen, class_2561 name, List<class_5481> description, final String ruleName, class_12279<E> enumRule, String translationKey) {
		gameRuleScreen.super(description, name);
		EditGameRulesScreenAccessor accessor = (EditGameRulesScreenAccessor) gameRuleScreen;

		// Overwrite line wrapping to account for button larger than vanilla's by 44 pixels.
		this.field_25629 = class_310.method_1551().field_1772.method_1728(name, 175 - 44);

		// Base translation key needs to be set before the button widget is created.
		this.rootTranslationKey = translationKey;
		this.buttonWidget = class_4185.method_46430(this.getValueText(accessor.getGameRules().method_76185(enumRule)), (buttonWidget) -> {
			accessor.getGameRules().method_76186(enumRule,
					((RuleTypeExtensions) (Object) enumRule).fabric_enumCycle(
							accessor.getGameRules().method_76185(enumRule)
					),
					null);
			buttonWidget.method_25355(this.getValueText(accessor.getGameRules().method_76185(enumRule)));
		}).method_46434(10, 5, 42, 20).method_46431();

		this.field_25630.add(this.buttonWidget);
	}

	public class_2561 getValueText(E value) {
		final String key = this.rootTranslationKey + "." + value.name().toLowerCase(Locale.ROOT);
		return class_2561.method_48321(key, value.toString());
	}

	@Override
	public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float tickDelta) {
		this.method_29989(context, this.method_73382(), this.method_73380());

		this.buttonWidget.method_46421(this.method_73389() - 44);
		this.buttonWidget.method_46419(this.method_73382());
		this.buttonWidget.method_25394(context, mouseX, mouseY, tickDelta);
	}
}
