/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.gamerule.v1;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import java.util.Objects;
import java.util.function.ToIntFunction;
import net.fabricmc.fabric.api.gamerule.v1.CustomGameRuleCategory;
import net.fabricmc.fabric.api.gamerule.v1.FabricGameRuleVisitor;
import net.fabricmc.fabric.impl.gamerule.RuleCategoryExtensions;
import net.fabricmc.fabric.impl.gamerule.RuleTypeExtensions;
import net.fabricmc.fabric.impl.gamerule.rpc.FabricGameRuleType;
import net.minecraft.class_11845;
import net.minecraft.class_12279;
import net.minecraft.class_1928;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4311;
import net.minecraft.class_5198;
import net.minecraft.class_7699;
import net.minecraft.class_7923;
import net.minecraft.class_8144;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

@ApiStatus.NonExtendable
public class GameRuleBuilder<T> {
    protected final T defaultValue;
    protected class_5198 category = class_5198.field_24100;
    protected @Nullable CustomGameRuleCategory fabricCategory = null;
    protected class_11845 type = class_11845.field_62399;
    protected @Nullable FabricGameRuleType fabricType;
    protected @Nullable ArgumentType<T> argumentType;
    protected class_1928.class_5199<T> acceptor;
    protected Codec<T> codec;
    protected ToIntFunction<T> commandResultSupplier;
    protected class_7699 requiredFeatures = class_7699.method_45397();

    protected GameRuleBuilder(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public static BooleanRuleBuilder forBoolean(boolean defaultValue) {
        return new BooleanRuleBuilder(defaultValue);
    }

    public static IntegerRuleBuilder forInteger(int defaultValue) {
        return new IntegerRuleBuilder(defaultValue);
    }

    public static DoubleRuleBuilder forDouble(double defaultValue) {
        return new DoubleRuleBuilder(defaultValue);
    }

    public static <E extends Enum<E>> EnumRuleBuilder<E> forEnum(E defaultValue) {
        return new EnumRuleBuilder<E>(defaultValue);
    }

    public GameRuleBuilder<T> category(class_5198 category) {
        this.category = category;
        return this;
    }

    public GameRuleBuilder<T> category(CustomGameRuleCategory category) {
        this.category(class_5198.field_24100);
        this.fabricCategory = category;
        return this;
    }

    public GameRuleBuilder<T> codec(Codec<T> codec) {
        this.codec = codec;
        return this;
    }

    public GameRuleBuilder<T> argumentType(ArgumentType<T> argumentType) {
        this.argumentType = argumentType;
        return this;
    }

    public GameRuleBuilder<T> commandResultSupplier(ToIntFunction<T> commandResultSupplier) {
        this.commandResultSupplier = commandResultSupplier;
        return this;
    }

    public GameRuleBuilder<T> requiredFeatures(class_7699 requiredFeatures) {
        this.requiredFeatures = requiredFeatures;
        return this;
    }

    public class_12279<T> build() {
        Objects.requireNonNull(this.category, "GameRule category cannot be null! Consider using GameRuleCategory.MISC instead.");
        Objects.requireNonNull(this.type, "GameRule type cannot be null! Consider using GameRuleType.INT instead.");
        if (this.fabricType != FabricGameRuleType.ENUM) {
            Objects.requireNonNull(this.argumentType, "GameRule argumentType cannot be null for non-enum rules!");
        }
        Objects.requireNonNull(this.acceptor, "GameRule acceptor cannot be null!");
        Objects.requireNonNull(this.codec, "GameRule codec cannot be null!");
        Objects.requireNonNull(this.commandResultSupplier, "GameRule commandResultSupplier cannot be null!");
        Objects.requireNonNull(this.defaultValue, "GameRule defaultValue cannot be null!");
        Objects.requireNonNull(this.requiredFeatures, "GameRule requiredFeatures cannot be null! Consider using FeatureSet.empty() instead.");
        this.codec.encodeStart((DynamicOps)JavaOps.INSTANCE, this.defaultValue).getOrThrow(error -> new IllegalStateException("Failed to serialize default value: " + error));
        class_12279 rule = new class_12279(this.category, this.type, this.argumentType, this.acceptor, this.codec, this.commandResultSupplier, this.defaultValue, this.requiredFeatures);
        if (this.fabricCategory != null) {
            ((RuleCategoryExtensions)rule).fabric_setCustomCategory(this.fabricCategory);
        }
        if (this.fabricType != null) {
            ((RuleTypeExtensions)rule).fabric_setType(this.fabricType);
        }
        return rule;
    }

    public class_12279<T> buildAndRegister(class_2960 id) {
        class_12279<T> rule = this.build();
        return (class_12279)class_2378.method_10230((class_2378)class_7923.field_64251, (class_2960)id, rule);
    }

    private static void visitDouble(class_4311 visitor, class_12279<Double> rule) {
        if (visitor instanceof FabricGameRuleVisitor) {
            ((FabricGameRuleVisitor)visitor).visitDouble(rule);
        }
    }

    private static <E extends Enum<E>> void visitEnum(class_4311 visitor, class_12279<E> rule) {
        if (visitor instanceof FabricGameRuleVisitor) {
            ((FabricGameRuleVisitor)visitor).visitEnum(rule);
        }
    }

    public static final class BooleanRuleBuilder
    extends GameRuleBuilder<Boolean> {
        BooleanRuleBuilder(boolean defaultValue) {
            super(defaultValue);
            this.type = class_11845.field_62400;
            this.acceptor = class_4311::method_27329;
            this.argumentType = BoolArgumentType.bool();
            this.codec = Codec.BOOL;
            this.commandResultSupplier = bool -> bool != false ? 1 : 0;
        }

        public BooleanRuleBuilder category(class_5198 category) {
            super.category(category);
            return this;
        }

        public BooleanRuleBuilder category(CustomGameRuleCategory category) {
            super.category(category);
            return this;
        }

        public BooleanRuleBuilder codec(Codec<Boolean> codec) {
            super.codec(codec);
            return this;
        }

        public BooleanRuleBuilder argumentType(ArgumentType<Boolean> argumentType) {
            super.argumentType(argumentType);
            return this;
        }

        public BooleanRuleBuilder commandResultSupplier(ToIntFunction<Boolean> commandResultSupplier) {
            super.commandResultSupplier(commandResultSupplier);
            return this;
        }

        public BooleanRuleBuilder requiredFeatures(class_7699 requiredFeatures) {
            super.requiredFeatures(requiredFeatures);
            return this;
        }
    }

    public static final class IntegerRuleBuilder
    extends NumberRuleBuilder<Integer> {
        IntegerRuleBuilder(int defaultValue) {
            super(defaultValue);
            this.type = class_11845.field_62399;
            this.acceptor = class_4311::method_27330;
            this.argumentType = IntegerArgumentType.integer();
            this.codec = Codec.INT;
            this.commandResultSupplier = integer -> integer;
        }

        public IntegerRuleBuilder category(class_5198 category) {
            super.category(category);
            return this;
        }

        public IntegerRuleBuilder category(CustomGameRuleCategory category) {
            super.category(category);
            return this;
        }

        public IntegerRuleBuilder codec(Codec<Integer> codec) {
            super.codec(codec);
            return this;
        }

        public IntegerRuleBuilder argumentType(ArgumentType<Integer> argumentType) {
            super.argumentType(argumentType);
            return this;
        }

        public IntegerRuleBuilder commandResultSupplier(ToIntFunction<Integer> commandResultSupplier) {
            super.commandResultSupplier(commandResultSupplier);
            return this;
        }

        public IntegerRuleBuilder requiredFeatures(class_7699 requiredFeatures) {
            super.requiredFeatures(requiredFeatures);
            return this;
        }

        public IntegerRuleBuilder minValue(Integer minValue) {
            return this.range(minValue, Integer.MAX_VALUE);
        }

        public IntegerRuleBuilder range(Integer minValue, Integer maxValue) {
            if ((Integer)this.defaultValue < minValue || (Integer)this.defaultValue > maxValue) {
                throw new IllegalArgumentException("Default value is out-of-bounds: " + String.valueOf(this.defaultValue));
            }
            return ((IntegerRuleBuilder)this.argumentType((ArgumentType)IntegerArgumentType.integer((int)minValue, (int)maxValue))).codec(Codec.intRange((int)minValue, (int)maxValue));
        }
    }

    public static final class DoubleRuleBuilder
    extends NumberRuleBuilder<Double> {
        DoubleRuleBuilder(double defaultValue) {
            super(defaultValue);
            this.fabricType = FabricGameRuleType.DOUBLE;
            this.acceptor = GameRuleBuilder::visitDouble;
            this.argumentType = DoubleArgumentType.doubleArg();
            this.codec = Codec.DOUBLE;
            this.commandResultSupplier = value -> Double.compare(value, 0.0);
        }

        public DoubleRuleBuilder category(class_5198 category) {
            super.category(category);
            return this;
        }

        public DoubleRuleBuilder category(CustomGameRuleCategory category) {
            super.category(category);
            return this;
        }

        public DoubleRuleBuilder codec(Codec<Double> codec) {
            super.codec(codec);
            return this;
        }

        public DoubleRuleBuilder argumentType(ArgumentType<Double> argumentType) {
            super.argumentType(argumentType);
            return this;
        }

        public DoubleRuleBuilder commandResultSupplier(ToIntFunction<Double> commandResultSupplier) {
            super.commandResultSupplier(commandResultSupplier);
            return this;
        }

        public DoubleRuleBuilder requiredFeatures(class_7699 requiredFeatures) {
            super.requiredFeatures(requiredFeatures);
            return this;
        }

        public DoubleRuleBuilder minValue(Double minValue) {
            return this.range(minValue, (Double)Double.MAX_VALUE);
        }

        public DoubleRuleBuilder range(Double minValue, Double maxValue) {
            if ((Double)this.defaultValue < minValue || (Double)this.defaultValue > maxValue) {
                throw new IllegalArgumentException("Default value is out-of-bounds: " + String.valueOf(this.defaultValue));
            }
            return ((DoubleRuleBuilder)this.argumentType((ArgumentType)DoubleArgumentType.doubleArg((double)minValue, (double)maxValue))).codec(Codec.doubleRange((double)minValue, (double)maxValue));
        }
    }

    public static final class EnumRuleBuilder<E extends Enum<E>>
    extends GameRuleBuilder<E> {
        private E[] supportedValues;

        EnumRuleBuilder(E defaultValue) {
            super(defaultValue);
            this.fabricType = FabricGameRuleType.ENUM;
            this.acceptor = GameRuleBuilder::visitEnum;
            this.argumentType = null;
            this.codec = EnumRuleBuilder.createEnumCodec(((Enum)defaultValue).getDeclaringClass());
            this.commandResultSupplier = value -> value.ordinal();
            this.supportedValues = (Enum[])((Enum)defaultValue).getDeclaringClass().getEnumConstants();
        }

        @Override
        public EnumRuleBuilder<E> category(class_5198 category) {
            super.category(category);
            return this;
        }

        @Override
        public EnumRuleBuilder<E> category(CustomGameRuleCategory category) {
            super.category(category);
            return this;
        }

        @Override
        public EnumRuleBuilder<E> codec(Codec<E> codec) {
            super.codec(codec);
            return this;
        }

        @Override
        public EnumRuleBuilder<E> argumentType(ArgumentType<E> argumentType) {
            super.argumentType(argumentType);
            return this;
        }

        @Override
        public EnumRuleBuilder<E> commandResultSupplier(ToIntFunction<E> commandResultSupplier) {
            super.commandResultSupplier(commandResultSupplier);
            return this;
        }

        @Override
        public EnumRuleBuilder<E> requiredFeatures(class_7699 requiredFeatures) {
            super.requiredFeatures(requiredFeatures);
            return this;
        }

        @SafeVarargs
        public final EnumRuleBuilder<E> supportedValues(E ... supportedValues) {
            if (class_8144.method_49089((Object[])supportedValues)) {
                throw new IllegalArgumentException("No values are supported!");
            }
            if (!ArrayUtils.contains((Object[])supportedValues, (Object)this.defaultValue)) {
                throw new IllegalArgumentException("Supported enum value must include the default " + String.valueOf(this.defaultValue));
            }
            this.supportedValues = supportedValues;
            return this;
        }

        @Override
        public class_12279<E> build() {
            class_12279 rule = super.build();
            ((RuleTypeExtensions)rule).fabric_setSupportedEnumValues((Enum[])this.supportedValues);
            return rule;
        }

        private static <E extends Enum<E>> Codec<E> createEnumCodec(Class<E> clazz) {
            return Codec.STRING.comapFlatMap(string -> {
                try {
                    return DataResult.success(Enum.valueOf(clazz, string));
                }
                catch (IllegalArgumentException exception) {
                    return DataResult.error(() -> string + " is not a valid value for enum + " + String.valueOf(clazz));
                }
            }, Enum::name);
        }
    }

    public static abstract class NumberRuleBuilder<T extends Number>
    extends GameRuleBuilder<T> {
        NumberRuleBuilder(T defaultValue) {
            super(defaultValue);
        }

        public abstract NumberRuleBuilder<T> minValue(T var1);

        public abstract NumberRuleBuilder<T> range(T var1, T var2);
    }
}

