/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.gamerule;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.fabricmc.fabric.impl.gamerule.RuleTypeExtensions;
import net.fabricmc.fabric.mixin.gamerule.GameRuleCommandAccessor;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.gamerules.GameRule;

public final class EnumRuleCommand {
    public static <E extends Enum<E>> void register(LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder, GameRule<E> enumRule) {
        String name = enumRule.toString();
        literalArgumentBuilder.then(Commands.literal((String)name).executes(context -> GameRuleCommandAccessor.invokeExecuteQuery((CommandSourceStack)context.getSource(), enumRule)));
        LiteralCommandNode ruleNode = Commands.literal((String)name).build();
        for (Enum supportedValue : ((RuleTypeExtensions)enumRule).fabric_getSupportedEnumValues()) {
            ruleNode.addChild((CommandNode)((LiteralArgumentBuilder)Commands.literal((String)supportedValue.toString()).executes(context -> EnumRuleCommand.executeAndSetEnum((CommandContext<CommandSourceStack>)context, supportedValue, enumRule))).build());
        }
        literalArgumentBuilder.then((CommandNode)ruleNode);
    }

    public static <E extends Enum<E>> int executeAndSetEnum(CommandContext<CommandSourceStack> context, E value, GameRule<E> enumRule) throws CommandSyntaxException {
        CommandSourceStack serverCommandSource = (CommandSourceStack)context.getSource();
        try {
            serverCommandSource.getLevel().getGameRules().set(enumRule, value, serverCommandSource.getServer());
        }
        catch (IllegalArgumentException e) {
            throw new SimpleCommandExceptionType((Message)Component.literal((String)e.getMessage())).create();
        }
        serverCommandSource.sendSuccess(() -> Component.translatable((String)"commands.gamerule.set", (Object[])new Object[]{enumRule.id(), enumRule.serialize((Object)value)}), true);
        return enumRule.getCommandResult(value);
    }
}

