/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.gamerule;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.function.Function;
import net.fabricmc.fabric.impl.gamerule.RuleTypeExtensions;
import net.fabricmc.fabric.impl.gamerule.rpc.FabricGameRuleType;
import net.fabricmc.fabric.impl.gamerule.rpc.FabricTypedRule;
import net.minecraft.class_11844;
import net.minecraft.class_11848;
import net.minecraft.class_12279;
import net.minecraft.class_3542;
import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_11844.class_12254.class})
public abstract class GameRuleRpcDispatcherRuleEntryMixin
implements FabricTypedRule {
    @Unique
    private @Nullable FabricGameRuleType fabricGameRuleType = null;

    @Override
    public @Nullable FabricGameRuleType getFabricType() {
        return this.fabricGameRuleType;
    }

    @Override
    public void setFabricType(FabricGameRuleType type) {
        this.fabricGameRuleType = Objects.requireNonNull(type);
    }

    @Inject(method={"<init>(Lnet/minecraft/class_12279;Ljava/lang/Object;)V"}, at={@At(value="RETURN")})
    private <T> void updateFabricType(class_12279<T> rule, Object value, CallbackInfo ci) {
        FabricGameRuleType type = ((RuleTypeExtensions)rule).fabric_getType();
        if (type == null) {
            return;
        }
        this.setFabricType(type);
    }

    @ModifyReturnValue(method={"method_76054(Lnet/minecraft/class_12279;)Lcom/mojang/serialization/MapCodec;"}, at={@At(value="RETURN")})
    private static <T, R extends class_11844.class_12254<T>> MapCodec<R> fabricTypeCodec(MapCodec<? extends class_11844.class_12254<T>> original, class_12279<T> gameRule) {
        MapCodec<class_11844.class_12254<T>> fabricTypedCodec = GameRuleRpcDispatcherRuleEntryMixin.fabric_createTypedCodec(gameRule);
        return Codec.mapEither(fabricTypedCodec, original).xmap(either -> (class_11844.class_12254)either.map(Function.identity(), Function.identity()), typedRule -> ((FabricTypedRule)typedRule).getFabricType() == null ? Either.right((Object)typedRule) : Either.left((Object)typedRule));
    }

    @Unique
    private static <T> class_11844.class_12254<T> fabric_checkType(class_12279<T> gameRule, FabricGameRuleType type, T object) {
        FabricGameRuleType gameRuleType = ((RuleTypeExtensions)gameRule).fabric_getType();
        if (gameRuleType != type) {
            throw new class_11848("Stated type \"" + String.valueOf((Object)type) + "\" mismatches with actual type \"" + String.valueOf((Object)gameRuleType) + "\" of gamerule \"" + gameRule.method_76144() + "\"");
        }
        return new class_11844.class_12254(gameRule, object);
    }

    @Unique
    private static <T> MapCodec<? extends class_11844.class_12254<T>> fabric_createTypedCodec(class_12279<T> rule) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_3542.method_28140(FabricGameRuleType::values).fieldOf("type").forGetter(arg -> ((RuleTypeExtensions)arg.comp_5161()).fabric_getType()), (App)rule.method_76155().fieldOf("value").forGetter(class_11844.class_12254::comp_5162)).apply((Applicative)instance, (type, object) -> GameRuleRpcDispatcherRuleEntryMixin.fabric_checkType(rule, type, object)));
    }
}

