/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.event.interaction;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.api.event.player.BlockEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_4970;

@Mixin(class_4970.class_4971.class)
public abstract class BlockBehaviourBlockStateBaseMixin {
	@Shadow
	protected abstract class_2680 asState();

	@Inject(method = "useItemOn", at = @At("HEAD"), cancellable = true)
	private void callUseItemOnEvent(class_1799 itemStack, class_1937 level, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult, CallbackInfoReturnable<class_1269> cir) {
		class_1269 result = BlockEvents.USE_ITEM_ON.invoker().useItemOn(itemStack, this.asState(), level, blockHitResult.method_17777(), player, interactionHand, blockHitResult);

		if (result != null) {
			cir.setReturnValue(result);
		}
	}

	@Inject(method = "useWithoutItem", at = @At("HEAD"), cancellable = true)
	private void callUseWithoutItemEvent(class_1937 level, class_1657 player, class_3965 blockHitResult, CallbackInfoReturnable<class_1269> cir) {
		class_1269 result = BlockEvents.USE_WITHOUT_ITEM.invoker().useWithoutItem(this.asState(), level, blockHitResult.method_17777(), player, blockHitResult);

		if (result != null) {
			cir.setReturnValue(result);
		}
	}
}
