/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.event.interaction.client;

import com.llamalad7.mixinextras.sugar.Local;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.api.event.client.player.ClientPlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2824;
import net.minecraft.class_2846;
import net.minecraft.class_2885;
import net.minecraft.class_2886;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_634;
import net.minecraft.class_636;
import net.minecraft.class_638;
import net.minecraft.class_7204;
import net.minecraft.class_746;

@Mixin(class_636.class)
public abstract class MultiPlayerGameModeMixin {
	@Shadow
	@Final
	private class_310 minecraft;
	@Shadow
	@Final
	private class_634 connection;

	@Shadow
	protected abstract void startPrediction(class_638 clientLevel, class_7204 predictiveAction);

	@Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/client/player/LocalPlayer;getAbilities()Lnet/minecraft/world/entity/player/Abilities;", ordinal = 0), method = "startDestroyBlock", cancellable = true)
	public void attackBlock(class_2338 pos, class_2350 direction, CallbackInfoReturnable<Boolean> info) {
		fabric_fireAttackBlockCallback(pos, direction, info);
	}

	@Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/client/player/LocalPlayer;getAbilities()Lnet/minecraft/world/entity/player/Abilities;", ordinal = 0), method = "continueDestroyBlock", cancellable = true)
	public void method_2902(class_2338 pos, class_2350 direction, CallbackInfoReturnable<Boolean> info) {
		if (this.minecraft.field_1724.method_31549().field_7477) {
			fabric_fireAttackBlockCallback(pos, direction, info);
		}
	}

	@Unique
	private void fabric_fireAttackBlockCallback(class_2338 pos, class_2350 direction, CallbackInfoReturnable<Boolean> info) {
		class_1269 result = AttackBlockCallback.EVENT.invoker().interact(minecraft.field_1724, minecraft.field_1687, class_1268.field_5808, pos, direction);

		if (result != class_1269.field_5811) {
			// Returning true will spawn particles and trigger the animation of the hand -> only for SUCCESS.
			info.setReturnValue(result == class_1269.field_5812);

			// We also need to let the server process the action if it's accepted.
			if (result.method_23665()) {
				startPrediction(minecraft.field_1687, id -> new class_2846(class_2846.class_2847.field_12968, pos, direction, id));
			}
		}
	}

	@Inject(method = "destroyBlock", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/block/Block;destroy(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V"))
	private void fabric$onBlockBroken(class_2338 pos, CallbackInfoReturnable<Boolean> cir, @Local class_2680 blockState) {
		ClientPlayerBlockBreakEvents.AFTER.invoker().afterBlockBreak(minecraft.field_1687, minecraft.field_1724, pos, blockState);
	}

	@Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;startPrediction(Lnet/minecraft/client/multiplayer/ClientLevel;Lnet/minecraft/client/multiplayer/prediction/PredictiveAction;)V"), method = "useItemOn", cancellable = true)
	public void interactBlock(class_746 player, class_1268 hand, class_3965 blockHitResult, CallbackInfoReturnable<class_1269> info) {
		// hook interactBlock between the world border check and the actual block interaction to invoke the use block event first
		// this needs to be in interactBlock to avoid sending a packet in line with the event javadoc

		if (player.method_7325()) return; // vanilla spectator check happens later, repeat it before the event to avoid false invocations

		class_1269 result = UseBlockCallback.EVENT.invoker().interact(player, player.method_73183(), hand, blockHitResult);

		if (result != class_1269.field_5811) {
			if (result.method_23665()) {
				// send interaction packet to the server with a new sequentially assigned id
				startPrediction((class_638) player.method_73183(), id -> new class_2885(hand, blockHitResult, id));
			}

			info.setReturnValue(result);
		}
	}

	@Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;ensureHasSentCarriedItem()V", ordinal = 0), method = "useItem", cancellable = true)
	public void interactItem(class_1657 player, class_1268 hand, CallbackInfoReturnable<class_1269> info) {
		// hook interactBlock between the spectator check and sending the first packet to invoke the use item event first
		// this needs to be in interactBlock to avoid sending a packet in line with the event javadoc
		class_1269 result = UseItemCallback.EVENT.invoker().interact(player, player.method_73183(), hand);

		if (result != class_1269.field_5811) {
			if (result == class_1269.field_5812) {
				// send interaction packet to the server with a new sequentially assigned id
				startPrediction((class_638) player.method_73183(), id -> new class_2886(hand, id, player.method_36454(), player.method_36455()));
			}

			info.setReturnValue(result);
		}
	}

	@Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/client/multiplayer/ClientPacketListener;send(Lnet/minecraft/network/protocol/Packet;)V", ordinal = 0), method = "attack", cancellable = true)
	public void attackEntity(class_1657 player, class_1297 entity, CallbackInfo info) {
		class_1269 result = AttackEntityCallback.EVENT.invoker().interact(player, player.method_73183(), class_1268.field_5808 /* TODO */, entity, null);

		if (result != class_1269.field_5811) {
			if (result == class_1269.field_5812) {
				this.connection.method_52787(class_2824.method_34206(entity, player.method_5715()));
			}

			info.cancel();
		}
	}
}
