/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.entity.event.v1.effect;

import net.fabricmc.fabric.api.entity.event.v1.effect.EffectEventContext;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;

public final class ServerMobEffectEvents {
    public static final Event<AllowAdd> ALLOW_ADD = EventFactory.createArrayBacked(AllowAdd.class, callbacks -> (effectInstance, entity, ctx) -> {
        for (AllowAdd callback : callbacks) {
            if (callback.allowAdd(effectInstance, entity, ctx)) continue;
            return false;
        }
        return true;
    });
    public static final Event<BeforeAdd> BEFORE_ADD = EventFactory.createArrayBacked(BeforeAdd.class, callbacks -> (effectInstance, entity, ctx) -> {
        for (BeforeAdd callback : callbacks) {
            callback.beforeAdd(effectInstance, entity, ctx);
        }
    });
    public static final Event<AfterAdd> AFTER_ADD = EventFactory.createArrayBacked(AfterAdd.class, callbacks -> (effectInstance, entity, ctx) -> {
        for (AfterAdd callback : callbacks) {
            callback.afterAdd(effectInstance, entity, ctx);
        }
    });
    public static final Event<AllowEarlyRemove> ALLOW_EARLY_REMOVE = EventFactory.createArrayBacked(AllowEarlyRemove.class, callbacks -> (effectInstance, entity, ctx) -> {
        for (AllowEarlyRemove callback : callbacks) {
            if (callback.allowEarlyRemove(effectInstance, entity, ctx)) continue;
            return false;
        }
        return true;
    });
    public static final Event<BeforeRemove> BEFORE_REMOVE = EventFactory.createArrayBacked(BeforeRemove.class, callbacks -> (effectInstance, entity, ctx) -> {
        for (BeforeRemove callback : callbacks) {
            callback.beforeRemove(effectInstance, entity, ctx);
        }
    });
    public static final Event<AfterRemove> AFTER_REMOVE = EventFactory.createArrayBacked(AfterRemove.class, callbacks -> (effectInstance, entity, ctx) -> {
        for (AfterRemove callback : callbacks) {
            callback.afterRemove(effectInstance, entity, ctx);
        }
    });

    private ServerMobEffectEvents() {
    }

    static {
        BEFORE_ADD.register((effectInstance, entity, ctx) -> ((class_1291)effectInstance.method_5579().comp_349()).onEffectAdded(effectInstance, entity));
        AFTER_ADD.register((effectInstance, entity, ctx) -> ((class_1291)effectInstance.method_5579().comp_349()).onEffectStarted(effectInstance, entity));
        BEFORE_REMOVE.register((effectInstance, entity, ctx) -> ((class_1291)effectInstance.method_5579().comp_349()).onEffectRemoved(effectInstance, entity));
    }

    @FunctionalInterface
    public static interface AfterRemove {
        public void afterRemove(class_1293 var1, class_1309 var2, EffectEventContext var3);
    }

    @FunctionalInterface
    public static interface BeforeRemove {
        public void beforeRemove(class_1293 var1, class_1309 var2, EffectEventContext var3);
    }

    @FunctionalInterface
    public static interface AllowEarlyRemove {
        public boolean allowEarlyRemove(class_1293 var1, class_1309 var2, EffectEventContext var3);
    }

    @FunctionalInterface
    public static interface AfterAdd {
        public void afterAdd(class_1293 var1, class_1309 var2, EffectEventContext var3);
    }

    @FunctionalInterface
    public static interface BeforeAdd {
        public void beforeAdd(class_1293 var1, class_1309 var2, EffectEventContext var3);
    }

    @FunctionalInterface
    public static interface AllowAdd {
        public boolean allowAdd(class_1293 var1, class_1309 var2, EffectEventContext var3);
    }
}

