/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.datagen.loot;

import java.util.Collections;

import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;

import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.fabricmc.fabric.impl.datagen.FabricDataGenHelper;
import net.fabricmc.fabric.mixin.datagen.loot.BlockLootSubProviderAccessor;

public class ConditionBlockLootSubProvider extends BlockLootSubProvider {
	private final BlockLootSubProvider parent;
	private final ResourceCondition[] conditions;

	public ConditionBlockLootSubProvider(BlockLootSubProvider parent, ResourceCondition[] conditions) {
		super(Collections.emptySet(), FeatureFlags.REGISTRY.allFlags(), ((BlockLootSubProviderAccessor) parent).getRegistries());

		this.parent = parent;
		this.conditions = conditions;
	}

	@Override
	public void generate() {
		throw new UnsupportedOperationException("generate() should not be called.");
	}

	@Override
	public void add(Block block, LootTable.Builder lootTable) {
		FabricDataGenHelper.addConditions(lootTable, conditions);
		this.parent.add(block, lootTable);
	}
}
