/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.datagen;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricProvidedTagBuilder;
import net.fabricmc.fabric.impl.datagen.FabricTagBuilder;
import net.minecraft.class_11389;
import net.minecraft.class_3495;
import net.minecraft.class_6862;

/**
 * Extends ProvidedTagBuilder to support setting the replace field.
 */
@SuppressWarnings({"rawtypes", "unchecked"})
@Mixin(class_11389.class)
interface TagAppenderMixin<E, T> extends FabricProvidedTagBuilder<E, T> {
	@Mixin(targets = "net.minecraft.data.tags.TagAppender$1")
	abstract class ProvidedTagBuilder1Mixin<E, T> implements TagAppenderMixin<E, T> {
		// the builder param
		@Shadow
		@Final
		class_3495 val$builder;

		@Override
		public class_11389<E, T> setReplace(boolean replace) {
			((FabricTagBuilder) this.val$builder).fabric_setReplace(replace);
			return (class_11389<E, T>) this;
		}

		@Override
		public class_11389<E, T> forceAddTag(class_6862<T> tag) {
			((FabricTagBuilder) this.val$builder).fabric_forceAddTag(tag.comp_327());
			return (class_11389<E, T>) this;
		}
	}

	@Mixin(targets = "net.minecraft.data.tags.TagAppender$2")
	abstract class ProvidedTagBuilder2Mixin<E, T> implements TagAppenderMixin<E, T> {
		// ProvidedTagBuilder.this
		@Shadow
		@Final
		class_11389 val$original;

		@Override
		public class_11389<E, T> setReplace(boolean replace) {
			((FabricProvidedTagBuilder) this.val$original).setReplace(replace);
			return (class_11389<E, T>) this;
		}

		@Override
		public class_11389<E, T> forceAddTag(class_6862<T> tag) {
			((FabricProvidedTagBuilder) this.val$original).forceAddTag(tag);
			return (class_11389<E, T>) this;
		}
	}
}
