/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.datagen;

import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.impl.tag.TagAliasGroup;
import net.minecraft.class_2378;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

public final class TagAliasGenerator {
	public static String getDirectory(class_5321<? extends class_2378<?>> registryKey) {
		String directory = "fabric/tag_aliases/";
		class_2960 registryId = registryKey.method_29177();

		if (!class_2960.field_33381.equals(registryId.method_12836())) {
			directory += registryId.method_12836() + '/';
		}

		return directory + registryId.method_12832();
	}

	public static <T> CompletableFuture<?> writeTagAlias(class_7403 writer, class_7784.class_7489 pathResolver, class_5321<? extends class_2378<T>> registryRef, class_2960 groupId, List<class_6862<T>> tags) {
		Path path = pathResolver.method_44107(groupId);
		return class_2405.method_64108(writer, TagAliasGroup.codec(registryRef), new TagAliasGroup<>(tags), path);
	}
}
