/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.datagen.v1.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_11389;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2474;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3495;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7784;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public abstract class FabricTagProvider<T>
extends class_2474<T> {
    private final FabricDataOutput output;
    private final Map<class_2960, AliasGroupBuilder> aliasGroupBuilders = new HashMap<class_2960, AliasGroupBuilder>();

    public FabricTagProvider(FabricDataOutput output, class_5321<? extends class_2378<T>> registryKey, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super((class_7784)output, registryKey, registriesFuture);
        this.output = output;
    }

    protected abstract void method_10514(class_7225.class_7874 var1);

    protected class_11389<class_5321<T>, T> builder(class_6862<T> tag) {
        class_3495 tagBuilder = this.method_27169(tag);
        return class_11389.method_71552((class_3495)tagBuilder);
    }

    protected AliasGroupBuilder aliasGroup(class_2960 groupId) {
        return this.aliasGroupBuilders.computeIfAbsent(groupId, key -> new AliasGroupBuilder());
    }

    protected AliasGroupBuilder aliasGroup(String group) {
        class_2960 groupId = class_2960.method_60655((String)this.output.getModId(), (String)group);
        return this.aliasGroupBuilders.computeIfAbsent(groupId, key -> new AliasGroupBuilder());
    }

    public Map<class_2960, AliasGroupBuilder> getAliasGroupBuilders() {
        return Collections.unmodifiableMap(this.aliasGroupBuilders);
    }

    public final class AliasGroupBuilder {
        private final List<class_6862<T>> tags = new ArrayList();

        private AliasGroupBuilder() {
        }

        public List<class_6862<T>> getTags() {
            return Collections.unmodifiableList(this.tags);
        }

        public AliasGroupBuilder add(class_6862<T> tag) {
            if (tag.comp_326() != FabricTagProvider.this.field_40957) {
                throw new IllegalArgumentException("Tag " + String.valueOf(tag) + " isn't from the registry " + String.valueOf(FabricTagProvider.this.field_40957));
            }
            this.tags.add(tag);
            return this;
        }

        @SafeVarargs
        public final AliasGroupBuilder add(class_6862<T> ... tags) {
            for (class_6862 tag : tags) {
                this.add((class_6862<T>)tag);
            }
            return this;
        }

        public AliasGroupBuilder add(class_2960 tag) {
            this.tags.add(class_6862.method_40092((class_5321)FabricTagProvider.this.field_40957, (class_2960)tag));
            return this;
        }

        public AliasGroupBuilder add(class_2960 ... tags) {
            for (class_2960 tag : tags) {
                this.tags.add(class_6862.method_40092((class_5321)FabricTagProvider.this.field_40957, (class_2960)tag));
            }
            return this;
        }
    }

    public static abstract class EntityTypeTagProvider
    extends FabricValueLookupTagProvider<class_1299<?>> {
        public EntityTypeTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, class_7924.field_41266, registriesFuture, type -> type.method_40124().method_40237());
        }
    }

    public static abstract class FluidTagProvider
    extends FabricValueLookupTagProvider<class_3611> {
        public FluidTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, class_7924.field_41270, registriesFuture, fluid -> fluid.method_40178().method_40237());
        }
    }

    public static abstract class ItemTagProvider
    extends FabricValueLookupTagProvider<class_1792> {
        @Nullable
        private final Function<class_6862<class_2248>, class_3495> blockTagBuilderProvider;

        public ItemTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture, @Nullable BlockTagProvider blockTagProvider) {
            super(output, class_7924.field_41197, registriesFuture, item -> item.method_40131().method_40237());
            this.blockTagBuilderProvider = blockTagProvider == null ? null : x$0 -> ((FabricTagProvider)blockTagProvider).method_27169(x$0);
        }

        public ItemTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            this(output, registriesFuture, null);
        }

        public void copy(class_6862<class_2248> blockTag, class_6862<class_1792> itemTag) {
            class_3495 blockTagBuilder = Objects.requireNonNull(this.blockTagBuilderProvider, "Pass Block tag provider via constructor to use copy").apply(blockTag);
            class_3495 itemTagBuilder = this.method_27169(itemTag);
            blockTagBuilder.method_26782().forEach(arg_0 -> ((class_3495)itemTagBuilder).method_27064(arg_0));
        }
    }

    public static abstract class BlockEntityTypeTagProvider
    extends FabricValueLookupTagProvider<class_2591<?>> {
        public BlockEntityTypeTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, class_7924.field_41255, registriesFuture, type -> type.method_53254().method_40237());
        }
    }

    public static abstract class BlockTagProvider
    extends FabricValueLookupTagProvider<class_2248> {
        public BlockTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, class_7924.field_41254, registriesFuture, block -> block.method_40142().method_40237());
        }
    }

    public static abstract class FabricValueLookupTagProvider<T>
    extends FabricTagProvider<T> {
        private final Function<T, class_5321<T>> valueToKey;

        protected FabricValueLookupTagProvider(FabricDataOutput output, class_5321<? extends class_2378<T>> registryKey, CompletableFuture<class_7225.class_7874> registriesFuture, Function<T, class_5321<T>> valueToKey) {
            super(output, registryKey, registriesFuture);
            this.valueToKey = valueToKey;
        }

        protected class_11389<T, T> valueLookupBuilder(class_6862<T> tag) {
            class_3495 tagBuilder = this.method_27169(tag);
            return class_11389.method_71552((class_3495)tagBuilder).method_71556(this.valueToKey);
        }
    }
}

