/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.datagen.v1.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.fabricmc.fabric.impl.datagen.FabricDataGenHelper;
import net.minecraft.class_161;
import net.minecraft.class_1860;
import net.minecraft.class_2405;
import net.minecraft.class_2446;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_8779;
import net.minecraft.class_8790;
import org.jetbrains.annotations.Nullable;

public abstract class FabricRecipeProvider
extends class_2446 {
    protected final FabricDataOutput output;

    public FabricRecipeProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super((class_7784)output, registriesFuture);
        this.output = output;
    }

    public abstract void method_10419(class_8790 var1);

    protected class_8790 withConditions(final class_8790 exporter, final ResourceCondition ... conditions) {
        Preconditions.checkArgument((conditions.length > 0 ? 1 : 0) != 0, (Object)"Must add at least one condition.");
        return new class_8790(){

            public void method_53819(class_2960 identifier, class_1860<?> recipe, @Nullable class_8779 advancementEntry) {
                FabricDataGenHelper.addConditions(recipe, conditions);
                exporter.method_53819(identifier, recipe, advancementEntry);
            }

            public class_161.class_162 method_53818() {
                return exporter.method_53818();
            }

            public class_2960 getRecipeIdentifier(class_2960 recipeId) {
                return exporter.getRecipeIdentifier(recipeId);
            }
        };
    }

    public CompletableFuture<?> method_56888(final class_7403 writer, final class_7225.class_7874 wrapperLookup) {
        final HashSet generatedRecipes = Sets.newHashSet();
        final ArrayList list = new ArrayList();
        this.method_10419(new class_8790(){

            public void method_53819(class_2960 recipeId, class_1860<?> recipe, @Nullable class_8779 advancement) {
                if (!generatedRecipes.add(recipeId)) {
                    throw new IllegalStateException("Duplicate recipe " + String.valueOf(recipeId));
                }
                class_6903 registryOps = wrapperLookup.method_57093((DynamicOps)JsonOps.INSTANCE);
                JsonObject recipeJson = ((JsonElement)class_1860.field_47319.encodeStart((DynamicOps)registryOps, recipe).getOrThrow(IllegalStateException::new)).getAsJsonObject();
                ResourceCondition[] conditions = FabricDataGenHelper.consumeConditions(recipe);
                FabricDataGenHelper.addConditions(recipeJson, conditions);
                list.add(class_2405.method_10320((class_7403)writer, (JsonElement)recipeJson, (Path)FabricRecipeProvider.this.field_39378.method_44107(recipeId)));
                if (advancement != null) {
                    JsonObject advancementJson = ((JsonElement)class_161.field_47179.encodeStart((DynamicOps)registryOps, (Object)advancement.comp_1920()).getOrThrow(IllegalStateException::new)).getAsJsonObject();
                    FabricDataGenHelper.addConditions(advancementJson, conditions);
                    list.add(class_2405.method_10320((class_7403)writer, (JsonElement)advancementJson, (Path)FabricRecipeProvider.this.field_39379.method_44107(advancement.comp_1919())));
                }
            }

            public class_161.class_162 method_53818() {
                return class_161.class_162.method_51698().method_708(class_5797.field_39377);
            }

            public class_2960 getRecipeIdentifier(class_2960 recipeId) {
                return FabricRecipeProvider.this.getRecipeIdentifier(recipeId);
            }
        });
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    protected class_2960 getRecipeIdentifier(class_2960 identifier) {
        return class_2960.method_60655((String)this.output.getModId(), (String)identifier.method_12832());
    }
}

