/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.attachment.sync;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.attachment.v1.AttachmentTarget;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.api.networking.v1.FriendlyByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.impl.attachment.AttachmentRegistryImpl;
import net.fabricmc.fabric.impl.attachment.AttachmentTypeImpl;
import net.fabricmc.fabric.impl.attachment.sync.AttachmentSyncException;
import net.fabricmc.fabric.impl.attachment.sync.AttachmentTargetInfo;
import net.fabricmc.fabric.impl.attachment.sync.SupportedAttachmentsConnection;
import net.fabricmc.fabric.impl.attachment.sync.clientbound.ClientboundAttachmentSyncPayload;
import net.fabricmc.fabric.mixin.attachment.ServerboundCustomPayloadPacketAccessor;
import net.fabricmc.fabric.mixin.attachment.VarIntAccessor;
import net.fabricmc.fabric.mixin.networking.accessor.ServerCommonPacketListenerImplAccessor;
import net.minecraft.ChatFormatting;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import org.jspecify.annotations.Nullable;

public record AttachmentChange(AttachmentTargetInfo<?> targetInfo, AttachmentType<?> type, byte[] data) {
    public static final StreamCodec<FriendlyByteBuf, AttachmentChange> PACKET_CODEC = StreamCodec.composite(AttachmentTargetInfo.PACKET_CODEC, AttachmentChange::targetInfo, (StreamCodec)Identifier.STREAM_CODEC.map(id -> Objects.requireNonNull(AttachmentRegistryImpl.get(id)), AttachmentType::identifier), AttachmentChange::type, (StreamCodec)ByteBufCodecs.BYTE_ARRAY, AttachmentChange::data, AttachmentChange::new);
    private static final int MAX_PADDING_SIZE_IN_BYTES = 265;
    private static final int MAX_DATA_SIZE_IN_BYTES = ServerboundCustomPayloadPacketAccessor.getMaxPayloadSize() - 265;

    public static AttachmentChange create(AttachmentTargetInfo<?> targetInfo, AttachmentType<?> type, @Nullable Object value, RegistryAccess registryAccess) {
        StreamCodec codec = ((AttachmentTypeImpl)type).streamCodec();
        Objects.requireNonNull(codec, "attachment stream codec cannot be null");
        Objects.requireNonNull(registryAccess, "registry access cannot be null");
        RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf((ByteBuf)FriendlyByteBufs.create(), registryAccess);
        if (value != null) {
            buf.writeBoolean(true);
            codec.encode((Object)buf, value);
        } else {
            buf.writeBoolean(false);
        }
        byte[] encoded = buf.array();
        if (encoded.length > MAX_DATA_SIZE_IN_BYTES) {
            throw new IllegalArgumentException("Data for attachment '%s' was too big (%d bytes, over maximum %d)".formatted(type.identifier(), encoded.length, MAX_DATA_SIZE_IN_BYTES));
        }
        return new AttachmentChange(targetInfo, type, encoded);
    }

    public static void partitionAndSendPackets(List<AttachmentChange> changes, ServerPlayer player) {
        int maxVarIntSize;
        Set<Identifier> supported = ((SupportedAttachmentsConnection)((ServerCommonPacketListenerImplAccessor)player.connection).getConnection()).fabric_getSupportedAttachments();
        changes.sort(Comparator.comparingInt(c -> c.data().length));
        ArrayList<AttachmentChange> packetChanges = new ArrayList<AttachmentChange>();
        int byteSize = maxVarIntSize = VarIntAccessor.getMaxByteSize();
        for (AttachmentChange change : changes) {
            if (!supported.contains(change.type.identifier())) continue;
            int size = 265 + change.data.length;
            if (byteSize + size > MAX_DATA_SIZE_IN_BYTES) {
                ServerPlayNetworking.send((ServerPlayer)player, (CustomPacketPayload)new ClientboundAttachmentSyncPayload(packetChanges));
                packetChanges.clear();
                byteSize = maxVarIntSize;
            }
            packetChanges.add(change);
            byteSize += size;
        }
        if (!packetChanges.isEmpty()) {
            ServerPlayNetworking.send((ServerPlayer)player, (CustomPacketPayload)new ClientboundAttachmentSyncPayload(packetChanges));
        }
    }

    public @Nullable Object decodeValue(RegistryAccess registryAccess) {
        StreamCodec codec = ((AttachmentTypeImpl)this.type).streamCodec();
        Objects.requireNonNull(codec, "codec was null");
        Objects.requireNonNull(registryAccess, "registry access cannot be null");
        RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.copiedBuffer((byte[])this.data), registryAccess);
        if (!buf.readBoolean()) {
            return null;
        }
        return codec.decode((Object)buf);
    }

    public void tryApply(Level level) throws AttachmentSyncException {
        AttachmentTarget target = this.targetInfo.getTarget(level);
        Object value = this.decodeValue(level.registryAccess());
        if (target == null) {
            MutableComponent errorMessageComponent = Component.empty();
            errorMessageComponent.append((Component)Component.translatable((String)"fabric-data-attachment-api-v1.unknown-target.title").withStyle(ChatFormatting.RED)).append(CommonComponents.NEW_LINE);
            errorMessageComponent.append(CommonComponents.NEW_LINE);
            errorMessageComponent.append((Component)Component.translatable((String)"fabric-data-attachment-api-v1.unknown-target.attachment-identifier", (Object[])new Object[]{Component.literal((String)String.valueOf(this.type.identifier())).withStyle(ChatFormatting.YELLOW)})).append(CommonComponents.NEW_LINE);
            errorMessageComponent.append((Component)Component.translatable((String)"fabric-data-attachment-api-v1.unknown-target.level", (Object[])new Object[]{Component.literal((String)String.valueOf(level.dimension().identifier())).withStyle(ChatFormatting.YELLOW)})).append(CommonComponents.NEW_LINE);
            this.targetInfo.appendDebugInformation(errorMessageComponent);
            throw new AttachmentSyncException((Component)errorMessageComponent);
        }
        target.setAttached(this.type, value);
    }
}

