/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.attachment;

import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import net.fabricmc.fabric.impl.attachment.AttachmentTargetImpl;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.PalettedContainerFactory;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SerializableChunkData;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SerializableChunkData.class})
abstract class SerializableChunkDataMixin {
    @Unique
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"SerializableChunkDataMixin");
    @Unique
    private @Nullable CompoundTag attachmentNbtData;

    SerializableChunkDataMixin() {
    }

    @Inject(method={"parse"}, at={@At(value="RETURN")})
    private static void storeAttachmentNbtData(LevelHeightAccessor heightLimitView, PalettedContainerFactory arg, CompoundTag nbt, CallbackInfoReturnable<SerializableChunkData> cir, @Share(value="attachmentDataNbt") LocalRef<CompoundTag> attachmentDataNbt) {
        SerializableChunkData serializer = (SerializableChunkData)cir.getReturnValue();
        if (serializer == null) {
            return;
        }
        CompoundTag attachmentNbtData = nbt.getCompound("fabric:attachments").orElse(null);
        if (attachmentNbtData != null) {
            ((SerializableChunkDataMixin)serializer).attachmentNbtData = attachmentNbtData;
        }
    }

    @Inject(method={"read"}, at={@At(value="RETURN")})
    private void setAttachmentDataInChunk(ServerLevel serverWorld, PoiManager pointOfInterestStorage, RegionStorageInfo storageKey, ChunkPos chunkPos, CallbackInfoReturnable<ProtoChunk> cir) {
        ProtoChunk chunk = (ProtoChunk)cir.getReturnValue();
        if (chunk != null && this.attachmentNbtData != null) {
            CompoundTag nbt = new CompoundTag();
            nbt.put("fabric:attachments", (Tag)this.attachmentNbtData);
            try (ProblemReporter.ScopedCollector reporter = new ProblemReporter.ScopedCollector(LOGGER);){
                ValueInput readView = TagValueInput.create((ProblemReporter)reporter, (HolderLookup.Provider)serverWorld.registryAccess(), (CompoundTag)nbt);
                ((AttachmentTargetImpl)chunk).fabric_readAttachmentsFromNbt(readView);
            }
        }
    }

    @Inject(method={"copyOf"}, at={@At(value="RETURN")})
    private static void storeAttachmentNbtData(ServerLevel world, ChunkAccess chunk, CallbackInfoReturnable<SerializableChunkData> cir) {
        try (ProblemReporter.ScopedCollector reporter = new ProblemReporter.ScopedCollector(LOGGER);){
            TagValueOutput writeView = TagValueOutput.createWithContext((ProblemReporter)reporter, (HolderLookup.Provider)world.registryAccess());
            ((AttachmentTargetImpl)chunk).fabric_writeAttachmentsToNbt((ValueOutput)writeView);
            CompoundTag attachmentNbtData = writeView.buildResult().getCompound("fabric:attachments").orElse(null);
            if (attachmentNbtData != null) {
                ((SerializableChunkDataMixin)cir.getReturnValue()).attachmentNbtData = attachmentNbtData;
            }
        }
    }

    @Inject(method={"write"}, at={@At(value="RETURN")})
    private void writeChunkAttachments(CallbackInfoReturnable<CompoundTag> cir) {
        if (this.attachmentNbtData != null) {
            ((CompoundTag)cir.getReturnValue()).put("fabric:attachments", (Tag)this.attachmentNbtData);
        }
    }
}

