/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.attachment.sync;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectArrayMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import net.fabricmc.fabric.api.attachment.v1.AttachmentTarget;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import org.jspecify.annotations.Nullable;

public sealed interface AttachmentTargetInfo<T> {
    public static final int MAX_SIZE_IN_BYTES = 9;
    public static final StreamCodec<ByteBuf, AttachmentTargetInfo<?>> PACKET_CODEC = ByteBufCodecs.BYTE.dispatch(AttachmentTargetInfo::getId, Type::packetCodecFromId);

    public Type<T> getType();

    default public byte getId() {
        return this.getType().id;
    }

    public @Nullable AttachmentTarget getTarget(Level var1);

    public void appendDebugInformation(MutableComponent var1);

    public record Type<T>(byte id, StreamCodec<ByteBuf, ? extends AttachmentTargetInfo<T>> packetCodec) {
        static Byte2ObjectMap<Type<?>> TYPES = new Byte2ObjectArrayMap();
        static Type<BlockEntity> BLOCK_ENTITY = new Type(0, BlockEntityTarget.PACKET_CODEC);
        static Type<Entity> ENTITY = new Type(1, EntityTarget.PACKET_CODEC);
        static Type<ChunkAccess> CHUNK = new Type(2, ChunkTarget.PACKET_CODEC);
        static Type<Level> WORLD = new Type(3, WorldTarget.PACKET_CODEC);

        public Type(byte id, StreamCodec<ByteBuf, ? extends AttachmentTargetInfo<T>> packetCodec) {
            TYPES.put(id, (Object)this);
            this.id = id;
            this.packetCodec = packetCodec;
        }

        static StreamCodec<ByteBuf, ? extends AttachmentTargetInfo<?>> packetCodecFromId(byte id) {
            return ((Type)Type.TYPES.get((byte)id)).packetCodec;
        }
    }

    public static final class WorldTarget
    implements AttachmentTargetInfo<Level> {
        public static final WorldTarget INSTANCE = new WorldTarget();
        static final StreamCodec<ByteBuf, WorldTarget> PACKET_CODEC = StreamCodec.unit((Object)INSTANCE);

        private WorldTarget() {
        }

        @Override
        public Type<Level> getType() {
            return Type.WORLD;
        }

        @Override
        public AttachmentTarget getTarget(Level world) {
            return world;
        }

        @Override
        public void appendDebugInformation(MutableComponent text) {
            text.append((Component)Component.translatable((String)"fabric-data-attachment-api-v1.unknown-target.target-type", (Object[])new Object[]{Component.translatable((String)"fabric-data-attachment-api-v1.unknown-target.target-type.world").withStyle(ChatFormatting.YELLOW)})).append(CommonComponents.NEW_LINE);
        }
    }

    public record ChunkTarget(ChunkPos pos) implements AttachmentTargetInfo<ChunkAccess>
    {
        static final StreamCodec<ByteBuf, ChunkTarget> PACKET_CODEC = ByteBufCodecs.VAR_LONG.map(ChunkPos::new, ChunkPos::toLong).map(ChunkTarget::new, ChunkTarget::pos);

        @Override
        public Type<ChunkAccess> getType() {
            return Type.CHUNK;
        }

        @Override
        public AttachmentTarget getTarget(Level world) {
            return world.getChunk(this.pos.x, this.pos.z);
        }

        @Override
        public void appendDebugInformation(MutableComponent text) {
            text.append((Component)Component.translatable((String)"fabric-data-attachment-api-v1.unknown-target.target-type", (Object[])new Object[]{Component.translatable((String)"fabric-data-attachment-api-v1.unknown-target.target-type.chunk").withStyle(ChatFormatting.YELLOW)})).append(CommonComponents.NEW_LINE);
            text.append((Component)Component.translatable((String)"fabric-data-attachment-api-v1.unknown-target.chunk-position", (Object[])new Object[]{Component.literal((String)(this.pos.x + ", " + this.pos.z)).withStyle(ChatFormatting.YELLOW)})).append(CommonComponents.NEW_LINE);
        }
    }

    public record EntityTarget(int networkId) implements AttachmentTargetInfo<Entity>
    {
        static final StreamCodec<ByteBuf, EntityTarget> PACKET_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, EntityTarget::networkId, EntityTarget::new);

        @Override
        public Type<Entity> getType() {
            return Type.ENTITY;
        }

        @Override
        public AttachmentTarget getTarget(Level world) {
            return world.getEntity(this.networkId);
        }

        @Override
        public void appendDebugInformation(MutableComponent text) {
            text.append((Component)Component.translatable((String)"fabric-data-attachment-api-v1.unknown-target.target-type", (Object[])new Object[]{Component.translatable((String)"fabric-data-attachment-api-v1.unknown-target.target-type.entity").withStyle(ChatFormatting.YELLOW)})).append(CommonComponents.NEW_LINE);
            text.append((Component)Component.translatable((String)"fabric-data-attachment-api-v1.unknown-target.entity-network-id", (Object[])new Object[]{Component.literal((String)String.valueOf(this.networkId)).withStyle(ChatFormatting.YELLOW)})).append(CommonComponents.NEW_LINE);
        }
    }

    public record BlockEntityTarget(BlockPos pos) implements AttachmentTargetInfo<BlockEntity>
    {
        static final StreamCodec<ByteBuf, BlockEntityTarget> PACKET_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, BlockEntityTarget::pos, BlockEntityTarget::new);

        @Override
        public Type<BlockEntity> getType() {
            return Type.BLOCK_ENTITY;
        }

        @Override
        public AttachmentTarget getTarget(Level world) {
            return world.getBlockEntity(this.pos);
        }

        @Override
        public void appendDebugInformation(MutableComponent text) {
            text.append((Component)Component.translatable((String)"fabric-data-attachment-api-v1.unknown-target.target-type", (Object[])new Object[]{Component.translatable((String)"fabric-data-attachment-api-v1.unknown-target.target-type.block-entity").withStyle(ChatFormatting.YELLOW)})).append(CommonComponents.NEW_LINE);
            text.append((Component)Component.translatable((String)"fabric-data-attachment-api-v1.unknown-target.block-entity-position", (Object[])new Object[]{Component.literal((String)this.pos.toShortString()).withStyle(ChatFormatting.YELLOW)})).append(CommonComponents.NEW_LINE);
        }
    }
}

